<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;

class TeacherListClasses extends Component
{
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $user,$delete;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        $this->delete = Classroom::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        $check = Classroom::query()->where('model_id', $this->delete->id)->get();
        if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem subscritores.');
            return back();
        }
        Classroom::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(Admin::class, 'Turma', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        $this->reset();


    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

 public function render()
{
    $this->user = $this->findGuardType()->user();
if ($this->user->role==2) {
    return view('livewire.admin.classes.teacher-list-classes', [
        'models' => $this->readyToLoad
            ? Classroom::query()
                ->whereRelation('subjects','teacher_id', $this->user->id)
                ->where(function ($query) {
                    $query->orWhere('name', 'like', '%' . $this->search . '%')
                        ->orWhere('slug', 'like', '%' . $this->search . '%');
                })
                ->orderBy('class')
                ->orderBy('name')
                ->paginate(10)
            : []
        ]
    );
}
else {
    return view('livewire.admin.classes.teacher-list-classes', [
        'models' => $this->readyToLoad
            ? Classroom::query()
            ->latest('updated_at')
                ->where(function ($query) {
                    $query->orWhere('name', 'like', '%' . $this->search . '%')
                        ->orWhere('slug', 'like', '%' . $this->search . '%');
                })
                ->orderBy('class')
                ->orderBy('name')
                ->paginate(10)
            : []
        ]
    );
  }
 }
}
