<?php

namespace App\Http\Livewire\User\Books;

use App\Models\Book;
use App\Models\Admin;
use App\Models\BookTitle;
use App\Models\ReadingStatus;
use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;


class UserShowBookChapters extends Component
{

    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;
    public $title, $photo, $category_id, $description, $user, $model;
    public $validatedData;
    public $updateMode = false;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];
    public function mount($slug)
    {
        $this->model = Book::query()->where('slug', $slug)->first();
        $this->title = $this->model->title;
        $this->category_id = $this->model->category_id;
        $this->description = $this->model->description;
    }
    public function submit($id)
    {
        $this->delete = BookTitle::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed($id)
    {
         $this->delete = BookTitle::query()->firstWhere('id', $id);
        $this->user = $this->findGuardType()->user();
        // Find or create a reading status record for the user and chapter
        $readingStatus = ReadingStatus::updateOrCreate(
            [

                'user_id' => $this->user->id,
                'book_id' => $this->delete->book_id,
                'book_title_id' => $this->delete->id,
            ],
            [
                'is_completed' => true,
            ]
        );
        Note::createSystemNotification(User::class, 'Livro', 'Aberto com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Aberto com sucesso ');
        return redirect()->route('user.show.chapter.info', $this->delete->slug);
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view(
            'livewire.user.books.user-show-book-chapters',
            [
                'models' => $this->readyToLoad
                    ? BookTitle::query()
                    ->latest('updated_at')
                    ->where('book_id', $this->model->id)
                    ->where(function ($query) {
                        $query->orWhere('title', 'like', '%' . $this->search . '%')
                            ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->paginate(10)
                    : []
            ]
        );
    }
}
