<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Book extends Model
{
    use HasFactory, Uuids, SoftDeletes, HasSlug;

    /**
     * stop the auto increment
     */
    public $incrementing = false;

    /**
     * type of auto-increment
     *
     * @string
     */
    protected $keyType = 'string';

    protected $fillable = [
        'title',
         'author',
        'slug',
        'category_id',
        'description',
        'media_name',
        'media_url',
        'pdf_name',
        'pdf_url',
    ];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function chapters(): HasMany
    {
        return $this->hasMany(BookTitle::class, 'book_id')->latest();
    }
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class)->latest();
    }
    public function book_status():HasOne
    {
        return $this->hasOne(BookStatus::class, 'book_id')->latest();
    }
}
