<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Editar capitulo de livro</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-12">
                                    <label for="title" class="form-label">Titulo</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                        id="title" required placeholder="Insira o titulo..."  name="title" wire:model="title" >
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-12">
                                    <label for="title" class="form-label">Livro </label>
                                    <select class="form-control @error('book_id') is-invalid @enderror"
                                            id="book_id" wire:model="book_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione o livro</option>
                                        @foreach($books as $book)
                                            <option value="{{ $book->id }}"> {{ $book->title }} </option>
                                        @endforeach
                                    </select>
                                    @error('book_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-12" wire:model.debounce.365ms="description" wire:ignore>
                                    <label for="description" class="form-label"><b> Descrição</b></label>
                                    <input id="description"
                                           value="{{ $description }}"
                                           type="hidden"
                                           name="description">
                                    <trix-editor
                                        input="description"></trix-editor>
                                    @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
