<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Adicionar comunicado</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Enviar para</label>
                                    <select class="form-control" wire:model="type">
                                        <option value="all">Todos</option>
                                        <option value="class">Classe Ou Turma</option>
                                        <option value="student">Estudante</option>
                                    </select>
                                </div>
                                
                                @if($type == "class" || $type == "student")
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Turma</label>
                                    <select class="form-control" wire:model="class_id">
                                        
                                        <option value="">Seleciona a Turma</option>
                                        @foreach($Classroom as $class)
                                            <option value="{{ $class->id }}"> {{ $class->class  }} - {{ $class->name }}  </option>
                                        @endforeach
                                    </select>
                                    @error('class_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                @endif




                                @if($type == "student")
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Estudante</label>
                                    <select class="form-control" wire:model="student_id">
                                        
                                        <option value="">Selecione o estudante</option>
                                        @foreach($students as $student)
                                            <option value="{{ $student->id }}"> {{ $student->name  }} </option>
                                        @endforeach
                                    </select>
                                    @error('class_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                @endif
                                
                                
                                





                                <div class="col-md-6">
                                    <label for="title" class="form-label">Descrição</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                        id="title" required placeholder="Insira a escrição..."  name="title" wire:model="title" >
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                <div wire:loading wire:target="photo"><span
                                    class="spinner-border spinner-border-sm"></span> Uploading
                            </div>
                            <div class="col-md-12">
                                <label for="photo" class="form-label"> Ficheiro</label>
                                <input type="file" class="form-control @error('photo') is-invalid @enderror"
                                    name="photo" required  wire:model ="photo" placeholder="Carregar ficheiro...">
                                @error('photo')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                              
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
