<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de Classes</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Turma</th>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Descrição</th>
                                            <th scope="col">Editar</th>
                                            <th scope="col">Ver estudantes</th>
                                            <th scope="col">Passagem de classe</th>
                                            <th scope="col">Deletar</th>
                                            <th scope="col">Data/Hora</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php ($count = 1); ?>
                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row"><?php echo e($count++); ?></th>
                                                <td><?php echo e($model->name); ?></td>
                                                <td><?php echo e($model->class); ?> Classe</td>
                                                <td><?php echo $model->description; ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.edit.class', $model->slug)); ?>"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-edit"></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.list.class.students', $model->slug)); ?>"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-eye"> Mostrar estudantes - <?php echo e($model->students->count()); ?></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.list.class.update.students', $model->slug)); ?>"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-eye"> Passagem de classe - <?php echo e($model->students->count()); ?></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button wire:click="submit('<?php echo e($model->id); ?>')"
                                                            class="btn btn-danger btn-sm">Deletar
                                                    </button>
                                                </td>
                                                <td><?php echo e(date('F d, Y h:i a', strtotime($model->created_at))); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        <?php echo e($models->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/1165120.cloudwaysapps.com/ttmjqktapb/public_html/resources/views/livewire/admin/classes/list-classes.blade.php ENDPATH**/ ?>