<?php

namespace App\Exports;

use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Subject;
use App\Models\Trimester;
use App\Models\User;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Date;
use Maatwebsite\Excel\Concerns\WithFooter;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup\Image;

class ExportExams implements FromView, ShouldAutoSize, WithEvents
{
    private $condition;
    public $schoolName, $subjectName, $className;

    public function __construct($condition)
    {
        $this->condition = $condition;

        $this->schoolName = 'COLÉGIO POLITÉCNICO DE MOÇAMBIQUE'; // Replace with your school name, eg: iFix Lda
        $this->subjectName = Subject::query()->where('id', $this->condition['subject_id'])->first()->name; // Fetch subject name
        $this->className = Classroom::query()->where('id', $this->condition['class_id'])->first()->name; // Fetch class name
    }

    public function view(): View
    {
        // Now get the exam records, but only for students actually in this classroom
        $examRecords = Exam::query()
            ->with(['subject', 'student'])
            ->join('users', function ($join) {
                $join->on('exams.student_id', '=', 'users.id')
                    ->where('users.classroom_id', '=', DB::raw('exams.classroom_id')); // Ensure student belongs to exam's classroom
            })// Join with students table
            ->select('exams.*', 'users.name as student_name') // Select the student name
            ->where('exams.classroom_id', $this->condition['class_id'])
            ->where('exams.trimester_id', $this->condition['trimester_id'])
            ->where('exams.subject_id', $this->condition['subject_id'])
            ->where('exams.year', $this->condition['year'])
            ->orderBy('student_name') // Order by student name
            ->distinct() // Make the exams distinct
            ->get();

        return view('exports.report', [
            'models' => $examRecords,
            'class_id' => $this->condition['class_id'],
            'subjectnamee' => $this->subjectName,
        ]);
    }

    public function registerEvents(): array
    {
        $logoPath = public_path('assets/images/logo.png');

        return [
            AfterSheet::class => function (AfterSheet $event) use ($logoPath) {
                // Set the height of the logo row
                $event->sheet->getRowDimension(1)->setRowHeight(80); // Adjust image height as needed

                // Create a drawing and set the image
                $drawing = new Drawing();
                $drawing->setPath($logoPath);
                $drawing->setWorksheet($event->sheet->getDelegate());
                $drawing->setCoordinates('D1'); // Adjust the cell coordinates as needed
                $drawing->setHeight(80); // Adjust image height as needed

                // Add the school name in the same cell as the logo
                $trimesterNameCell = $event->sheet->getCell('C1');
                $trimesterNameCell->setValue($this->condition['trimester_id']. '    º Trimestre'); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $schoolNameCell = $event->sheet->getCell('D1');
                $schoolNameCell->setValue($this->schoolName); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $subjectNameCell = $event->sheet->getCell('F1');
                $subjectNameCell->setValue($this->subjectName); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $classNameCell = $event->sheet->getCell('G1');
                $classNameCell->setValue($this->className); // Use the school name from the view
                // Remove the background color of the first row
                $event->sheet->getStyle('1:1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_NONE);

                // Set font color for the first row
                $event->sheet->getStyle('1:1')->getFont()->getColor()
                    ->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLACK);

                // Make the first row bold
                $event->sheet->getStyle('1:1')->getFont()->setBold(true);
            },
        ];
    }

    public function headings(): array
    {
        return [
            'Subject: ' . $this->subjectName,
            'Class: ' . $this->className,
            '', // Add more columns as needed
        ];
    }
}
