<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PreEnrollment;
use Barryvdh\DomPDF\Facade\Pdf;

class EnrollmentPdfController extends Controller
{
    public function download($id)
    {
        $pre = PreEnrollment::with(['desiredClassroom', 'resultingStudent'])->findOrFail($id);

        $pdf = Pdf::loadView('pdf.ficha-inscricao', ['pre' => $pre])
            ->setPaper('a4', 'portrait');

        // Watermark em todas as páginas via DomPDF canvas
        $logoPath = public_path('assets/images/logo.png');
        if (!file_exists($logoPath)) {
            $logoPath = public_path('images/certificates/copmoz_logo.png');
        }

        if (file_exists($logoPath)) {
            $pdf->render();
            $canvas = $pdf->getDomPDF()->getCanvas();
            $w = 200;
            $h = 200;
            $x = (595 - $w) / 2;
            $y = (842 - $h) / 2;

            // page_script executa em cada página automaticamente
            $canvas->page_script(function ($pageNumber, $pageCount, $canvas) use ($logoPath, $x, $y, $w, $h) {
                $canvas->set_opacity(0.07);
                $canvas->image($logoPath, $x, $y, $w, $h);
                $canvas->set_opacity(1);
            });
        }

        return $pdf->download("Ficha_Inscricao_{$pre->code}.pdf");
    }
}
