<?php

namespace App\Http\Controllers;

use App\Models\Book;
use Illuminate\Support\Facades\Storage;

class FlipController extends Controller
{
    public function index($slug)
    {

        // Encode the PDF data to base64
        $book = Book::query()->where('slug', $slug)->first();
        $pdfUrl = $book->pdf_url; // Replace with the actual URL
        // Specify the URL of the PDF file on the live server
        // $pdfUrl = 'https://alphabet.nyc3.digitaloceanspaces.com/stack/test.pdf'; // Replace with the actual URL

        // Fetch the PDF from the URL
        $pdfData = file_get_contents($pdfUrl);

        // Check if the PDF data was successfully fetched
        if ($pdfData === false) {
            return 'Failed to fetch the PDF';
        }
        $base64PDF = base64_encode($pdfData);

        return view('flipbook', compact('base64PDF', 'book'));
    }
}
