<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Exam;
use App\Models\User;
use Carbon\Carbon;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;

class AcademicEditResults extends Component {
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search;
    public $model, $name;
    public $selectedYear = ''; // Add property to hold the selected year
    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch() {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public $confirmingEditMarks;

    public function loadData() {
        $this->readyToLoad = true;
    }

    public function mount( $slug ) {
        $this->model = User::query()->where( 'slug', $slug )->first();
        $this->user = $this->findGuardType()->user();

        // Super Admin (role 0) always has access
        if ($this->user->role == 0) {
            $this->confirmingEditMarks = true;
        }
        // For other roles, check canEditMarks permission
        // If not set, role 1 (Secretaria) and role 3 (Reg Academico) have access by default
        elseif (isset($this->user->canEditMarks)) {
            $this->confirmingEditMarks = $this->user->canEditMarks == 'yes';
        }
        // Default access for Secretaria (role 1) if canEditMarks not configured
        else {
            $this->confirmingEditMarks = $this->user->role == 1;
        }
    }

    public function render() {
        $currentYear = Carbon::now()->year;

        // Apply filter by selected year if it's not empty
        $query = Exam::query()
            ->latest( 'updated_at' )
            ->where( 'student_id', $this->model->id )
            ->where( function ( $query ) {
                $query->orWhere( 'ACS1a', 'like', '%' . $this->search . '%' )
                    ->orWhere( 'ACS2a', 'like', '%' . $this->search . '%' )
                    ->orWhere( 'MACS', 'like', '%' . $this->search . '%' );

            })/*
            ->whereNull( 'deleted_at')*/;

        if ( !empty( $this->selectedYear ) ) {
            $query->where('year', $this->selectedYear)
                ->whereYear( 'updated_at', $this->selectedYear );
        } else {
            // If no year is selected, default to current year
            $query->where('year', $currentYear)
                ->whereYear( 'updated_at', $currentYear );
        }

        // Paginate the results
        $models = $this->readyToLoad ? $query->paginate( 100 ) : [];

        return view( 'livewire.admin.classes.academic-edit-results', [
            'models'      => $models,
            'currentYear' => $currentYear, // Pass the current year to the view
        ] );
    }
}
