<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Project;
use App\Models\User;
use App\Models\Exam;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;


class ListClassUpdateStudents extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search;
    public $model, $project, $name, $classroom1, $classstatus, $year_edu, $year;
    protected $queryString = ['search'];
    public $studentid  = [];
    
    // Este array armazenará os anos de 2023 até o ano atual
    public $years = [];

    protected string $paginationTheme = 'bootstrap';

    /*public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData1()
    {
        $this->readyToLoad = true;
    }*/

    protected $rules = [
        'year_edu' => 'required',
        //'email' => 'required|email',
    ];

    public function mount($slug)
    {
        $this->model = Classroom::query()->where('slug', $slug)->first();
        $this->name = $this->model->name;
        // Inclui ano atual + próximo ano para passagem de classe
        $this->years = range(2023, date('Y') + 1);
        // Define valores padrão
        $this->year = date('Y'); // Ano atual para "De"
        $this->year_edu = date('Y') + 1; // Próximo ano para "Para"
    }
    
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function updateStudent(){
        $validatedData = $this->validate();
        //echo "asd";
        //print_r($this->$studentid);
        //echo $this->classroom1;
        //dd($this->studentid,$this->classroom1,$this->year_edu);
        foreach($this->studentid as $student){
            //echo $student;
            User::where("id",$student)->update(["classroom_id"=>$this->classroom1,"year_edu"=>$this->year_edu]);
        }
         $this->alert('success', 'Registro atualizado com sucesso!');
    }

    public function render()
    {
        // Verifica se o ano foi selecionado
        if (!empty($this->year)) {
            // Para o ano corrente, utiliza a tabela "users"
            if ($this->year == date('Y')) {
                // Filtra os usuários pela tabela "users" com base no ano "year_edu"
                $users = User::where("classroom_id", $this->model->id)
                             ->where("year_edu", $this->year) // Filtra pelo ano de matrícula (year_edu)
                             ->distinct() // Garante que não haja repetições
                             ->pluck('id'); // Pegue os IDs dos estudantes

                // Converte o resultado para um array
                $userss = $users->toArray();
            } else {
                // Para anos anteriores, utiliza a tabela "Exam"
                $users = Exam::where("trimester_id", "1")
                             ->where("year", $this->year) // Filtra pelo ano dos exames
                             ->where("classroom_id", $this->model->id)
                             ->distinct()
                             ->pluck('student_id'); // Pegue os IDs dos estudantes

                // Converte o resultado para um array
                $userss = $users->toArray();
            }

            // Retorna a view com os estudantes filtrados
            return view('livewire.admin.classes.list-class-update-students', [
                'models' => User::query()
                    ->where(function ($query) {
                        $query->orWhere('name', 'like', '%' . $this->search . '%')
                              ->orWhere('sex', 'like', '%' . $this->search . '%')
                              ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                              ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->whereIn('id', $userss) // Aplica o filtro de estudantes pela tabela "users"
                    ->orderBy('name') // Ordena os estudantes por nome
                    ->paginate(500),

                "classroom" => Classroom::orderBy("class")->get(),
            ]);
        } else {
            // Caso o ano não tenha sido selecionado, retorna todos os estudantes da turma
            return view('livewire.admin.classes.list-class-update-students', [
                'models' => User::query()
                    ->where(function ($query) {
                        $query->orWhere('name', 'like', '%' . $this->search . '%')
                              ->orWhere('sex', 'like', '%' . $this->search . '%')
                              ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                              ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->where('classroom_id', $this->model->id) // Aplica o filtro pela turma
                    ->orderBy('name') // Ordena os estudantes por nome
                    ->paginate(500),

                "classroom" => Classroom::orderBy("class")->get(),
            ]);
        }
    }
}
