<?php
namespace App\Http\Livewire\Admin\Fee;

use Livewire\Component;
use App\Models\FeesDiscount as discount;
use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;

class FeesDiscount extends Component
{
    public $name, $discount_code, $discount_type = 'percentage', $percentage, $amount, $description;
    public $search = '';
    public $feesDiscounts = [];
    public $type = 'student';
    public $class_id;
    public $student_id;
    public $student_type;
    public $title;
    public $months = []; 

    protected $rules = [
        'name' => 'required|string|max:255',
        'discount_code' => 'required|string|max:255|unique:fees_discounts,discount_code',
        'discount_type' => 'required|in:percentage,fix_amount',
        'percentage' => 'required_if:discount_type,percentage|numeric|min:0|max:100',
        'amount' => 'required_if:discount_type,fix_amount|numeric|min:0',
        'description' => 'nullable|string|max:1000',
        'student_id' => 'required',
        'months' => 'required|array',

    ];

    public function mount()
    {
        $this->loadFeesDiscounts();
    }

    public function loadFeesDiscounts()
    {
        $this->feesDiscounts = discount::where('name', 'like', '%'.$this->search.'%')
            ->orWhere('discount_code', 'like', '%'.$this->search.'%')
            ->get();
    }

    public function save()
    {
        $this->validate();

        discount::create([
            'name' => $this->name,
            'discount_code' => $this->discount_code,
            'discount_type' => $this->discount_type,
            'percentage' => $this->discount_type == 'percentage' ? $this->percentage : null,
            'amount' => $this->discount_type == 'fix_amount' ? $this->amount : null,
            'description' => $this->description,
            'student_id' => $this->student_id,
            'months' => implode(",",$this->months),
        ]);

        $this->resetForm();
        $this->loadFeesDiscounts();
    }

    public function resetForm()
    {
        $this->name = '';
        $this->discount_code = '';
        $this->discount_type = 'percentage';
        $this->percentage = null;
        $this->amount = null;
        $this->description = '';
    }

    public function edit($id)
    {
        $discount = discount::findOrFail($id);
        $this->name = $discount->name;
        $this->discount_code = $discount->discount_code;
        $this->discount_type = $discount->discount_type;
        $this->percentage = $discount->percentage;
        $this->amount = $discount->amount;
        $this->description = $discount->description;
    }

    public function delete($id)
    {
        discount::findOrFail($id)->delete();
        $this->loadFeesDiscounts();
    }

    public function updatedSearch()
    {
        $this->loadFeesDiscounts();
    }

    public function render()
    {
         if(!empty($this->type)) {
            return view('livewire.admin.fee.fees-discount', [
                'classrooms' => Classroom::query()->orderBy('class')->get(),
                'students' => User::when($this->class_id, function($query) {
                    return $query->where('classroom_id', $this->class_id);
                })->orderBy('name')->get(),
            ]);
        } else {
            return view('livewire.admin.fee.fees-discount', [
                'classrooms' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
        //return view('livewire.admin.fee.fees-discount');
    }
}
