<?php

namespace App\Http\Livewire\Auth\Admin;

use App\Jobs\MailJob;
use App\Models\Admin;
use Illuminate\Support\Facades\URL;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class AdminForgot extends Component
{
    use LivewireAlert;

    public $email;

    protected array $rules = [
        'email' => ['required', 'string', 'email', 'exists:admins']
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    /**
     * reset user password here
     */
    public function resetPassword()
    {
        $this->validate();

        // fetch the user here
        $user = Admin::query()->firstWhere('email', $this->email);

        // send email here
        dispatch(new MailJob(
            $user->name,
            $user->email,
            'Redefinição de senha da conta',
            'Você está recebendo este e-mail porque recebemos uma solicitação de redefinição de senha da sua conta. Esta redefinição de senha
            o link expirará em 60 minutos. Se você não solicitou uma redefinição de senha, nenhuma ação adicional será necessária.',
            true,
            URL::temporarySignedRoute('admin.reset', now()->addMinutes(60), ['token' => encrypt($this->email, true)]),
            '<<< REDEFINIR A SENHA >>>'
        ))->onQueue('emails')->delay(2);

        $this->reset(['email']);
        $this->alert('success', 'Um novo link de redefinição de senha foi enviado para seu endereço de e-mail. Verifique e use-o para atualizar sua senha.');
    }

    public function render()
    {
        return view('livewire.auth.admin.admin-forgot')->layout('layouts.auth');
    }
}
