<?php

namespace App\Http\Livewire\Guardian;

use App\Models\Noticeboard;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;
use Livewire\WithPagination;

class Comunicados extends Component
{
    use WithPagination;

    protected $listeners = ['studentSwitched' => '$refresh'];

    public function getActiveStudentProperty(): ?User
    {
        $id = Session::get('guardian_student_id');
        $g  = Auth::guard('guardian')->user();
        if (!$id || !$g) return null;
        return $g->students()->with('classroom')->find($id);
    }

    public function getNoticesProperty()
    {
        $st = $this->active_student;
        return Noticeboard::where('status', 'active')
            ->where(fn($q) => $q->whereNull('class_id')
                ->orWhere('class_id', $st?->classroom_id)
                ->orWhere('student_id', $st?->id))
            ->latest()
            ->paginate(15);
    }

    public function render()
    {
        return view('livewire.guardian.comunicados', [
            'active_student' => $this->active_student,
            'notices'        => $this->notices,
        ])->layout('layouts.app');
    }
}
