<?php

namespace App\Http\Livewire\Guardian\Inc;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class Header extends Component
{
    protected $listeners = ['studentSwitched' => 'refreshActiveStudent'];

    public $activeStudentId;

    public function mount()
    {
        $this->activeStudentId = Session::get('guardian_student_id');
    }

    public function switchStudent(string $studentId)
    {
        $guardian = Auth::guard('guardian')->user();
        if ($guardian && $guardian->hasStudent($studentId)) {
            Session::put('guardian_student_id', $studentId);
            $this->activeStudentId = $studentId;
            $this->emit('studentSwitched', $studentId);
        }
    }

    public function refreshActiveStudent(string $studentId)
    {
        $this->activeStudentId = $studentId;
    }

    public function logout()
    {
        Auth::guard('guardian')->logout();
        Session::forget('guardian_student_id');
        return redirect()->route('guardian.login');
    }

    public function render()
    {
        $guardian = Auth::guard('guardian')->user();
        $students = $guardian
            ? $guardian->students()->with('classroom')->get()
            : collect([]);
        $activeStudent = $students->firstWhere('id', $this->activeStudentId);

        return view('livewire.guardian.inc.header', [
            'guardian'      => $guardian,
            'students'      => $students,
            'activeStudent' => $activeStudent,
        ]);
    }
}
