<?php

namespace App\Http\Livewire\User\Exams;

use App\Models\Exam;
use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Carbon\Carbon;


class StudentListExams extends Component
{

    // Disable lazy loading for this component
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete, $years;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function mount()
    {
       // Set the default value for $search to the current year
       $this->search = Carbon::now()->year;

       // Generate an array of years from the current year to 2023 (adjust as needed)
       $this->years = array_combine(range(Carbon::now()->year, 2023), range(Carbon::now()->year, 2023));

       // Add the "Ano Corrente" string for the current year
       $this->years[Carbon::now()->year] = 'Ano Corrente';
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        $this->delete = Exam::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja excluir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled

        Exam::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(User::class, 'Teste', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();


    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view('livewire.user.exams.student-list-exams', [
            'models' => $this->readyToLoad ? $this->findGuardType()
                ->user()
                ->load('exams')
                ->exams()
                ->latest('updated_at')
                ->where('trimester_id', '1')
                ->where('year', $this->search)
                ->paginate(100) : []
        ]);
    }
}
