<?php

namespace App\Http\Livewire\User\Inc;

use Illuminate\Support\Facades\Auth;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;

class Sidebar extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    public $user;

    public function logout()
    {
        $guard = $this->findGuardType();
        if ($guard) {
            $guard->logout();
        }
        return redirect()->route('login');
    }

    public function render()
    {
        $this->user = Auth::guard('web')->user();
        return view('livewire.user.inc.sidebar');
    }
}
