<?php

namespace App\Http\Livewire;

use App\Services\CertificateService;
use Livewire\Component;

class VerifyCertificate extends Component
{
    public $verificationCode = '';
    public $result = null;
    public $searched = false;
    public $error = null;

    protected $queryString = ['verificationCode' => ['as' => 'code']];

    public function mount($code = null)
    {
        if ($code) {
            $this->verificationCode = $code;
            $this->verify();
        }
    }

    public function verify()
    {
        $this->searched = true;
        $this->error = null;
        $this->result = null;

        if (empty(trim($this->verificationCode))) {
            $this->error = 'Por favor, insira o codigo de verificacao.';
            return;
        }

        $service = app(CertificateService::class);
        $this->result = $service->verifyCertificate(trim($this->verificationCode));

        if (!$this->result) {
            $this->error = 'Certificado nao encontrado. Verifique o codigo e tente novamente.';
        }
    }

    public function clearSearch()
    {
        $this->verificationCode = '';
        $this->result = null;
        $this->searched = false;
        $this->error = null;
    }

    public function render()
    {
        return view('livewire.verify-certificate')
            ->layout('layouts.public');
    }
}
