<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class CheckAdminPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $permission
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $permission)
    {
        $admin = auth()->guard('admin')->user();

        if (!$admin) {
            Log::warning('Tentativa de acesso sem autenticação', [
                'url' => $request->url(),
                'permission_required' => $permission,
            ]);

            if ($request->expectsJson()) {
                return response()->json(['error' => 'Não autenticado'], 401);
            }

            return redirect()->route('admin.login')
                ->with('error', 'Você precisa estar autenticado.');
        }

        if (!$admin->hasPermission($permission)) {
            Log::warning('Acesso negado por falta de permissão', [
                'admin_id' => $admin->id,
                'admin_name' => $admin->name,
                'admin_role' => $admin->getRoleName(),
                'url' => $request->url(),
                'permission_required' => $permission,
            ]);

            if ($request->expectsJson()) {
                return response()->json([
                    'error' => 'Acesso negado',
                    'message' => 'Você não tem permissão para acessar este recurso.',
                    'permission_required' => $permission,
                ], 403);
            }

            return redirect()->route('admin.home')
                ->with('error', 'Você não tem permissão para acessar esta página.');
        }

        return $next($request);
    }
}
