<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default SMS Gateway
    |--------------------------------------------------------------------------
    |
    | This option controls the default SMS gateway that will be used for
    | sending SMS messages. You can set this to any of the gateways
    | defined in the "gateways" array below.
    |
    | Supported: "twilio", "movitel"
    |
    */

    'default' => env('SMS_GATEWAY', 'movitel'),

    /*
    |--------------------------------------------------------------------------
    | SMS Gateways
    |--------------------------------------------------------------------------
    |
    | Here you may configure all of the SMS gateways used by your application.
    | Multiple gateways are supported so you can configure as many as you need.
    |
    */

    'gateways' => [

        'twilio' => [
            'driver' => 'twilio',
            'sid' => env('TWILIO_SID'),
            'token' => env('TWILIO_TOKEN'),
            'from' => env('TWILIO_FROM'),
        ],

        'movitel' => [
            'driver' => 'movitel',
            'api_url' => env('MOVITEL_SMS_API_URL', 'https://sms.itcore.app/api/http/sms/send'),
            'api_token' => env('MOVITEL_SMS_API_TOKEN'),
            'sender_id' => env('MOVITEL_SMS_SENDER_ID', 'COPMOZ'),
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Country Code
    |--------------------------------------------------------------------------
    |
    | The default country code to prepend to phone numbers.
    | For Mozambique, this is 258.
    |
    */

    'country_code' => env('SMS_COUNTRY_CODE', '258'),

    /*
    |--------------------------------------------------------------------------
    | SMS Logging
    |--------------------------------------------------------------------------
    |
    | Enable or disable logging of sent SMS messages to the database.
    |
    */

    'log_messages' => env('SMS_LOG_MESSAGES', true),

];
