<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_confirmations', function (Blueprint $table) {
            // Índices individuais para queries rápidas
            $table->index('student_id', 'idx_payment_confirmations_student_id');
            $table->index('class_id', 'idx_payment_confirmations_class_id');
            $table->index('type', 'idx_payment_confirmations_type');

            // Índice composto para queries comuns
            $table->index(['student_id', 'type'], 'idx_payment_confirmations_student_type');

            // Índice para soft deletes se existir
            if (Schema::hasColumn('payment_confirmations', 'deleted_at')) {
                $table->index('deleted_at', 'idx_payment_confirmations_deleted_at');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_confirmations', function (Blueprint $table) {
            $table->dropIndex('idx_payment_confirmations_student_id');
            $table->dropIndex('idx_payment_confirmations_class_id');
            $table->dropIndex('idx_payment_confirmations_type');
            $table->dropIndex('idx_payment_confirmations_student_type');

            if (Schema::hasColumn('payment_confirmations', 'deleted_at')) {
                $table->dropIndex('idx_payment_confirmations_deleted_at');
            }
        });
    }
};
