<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Primeiro, remover duplicatas existentes (manter apenas a mais recente)
        DB::statement("
            DELETE pr1 FROM payment_references pr1
            INNER JOIN payment_references pr2
            WHERE pr1.student_id = pr2.student_id
                AND pr1.fee_month = pr2.fee_month
                AND pr1.fee_year = pr2.fee_year
                AND pr1.status = pr2.status
                AND pr1.status = 'pending'
                AND pr1.id < pr2.id
        ");

        // Skip if indexes already exist - check manually
        try {
            Schema::table('payment_references', function (Blueprint $table) {
                // Try to add unique index - will fail silently if exists
                DB::statement('ALTER TABLE payment_references ADD UNIQUE INDEX unique_pending_payment_reference (student_id, fee_month, fee_year, status)');
            });
        } catch (\Exception $e) {
            // Index already exists, continue
        }

        try {
            Schema::table('payment_references', function (Blueprint $table) {
                DB::statement('ALTER TABLE payment_references ADD INDEX idx_payment_references_student_id (student_id)');
            });
        } catch (\Exception $e) {}

        try {
            Schema::table('payment_references', function (Blueprint $table) {
                DB::statement('ALTER TABLE payment_references ADD INDEX idx_payment_references_status (status)');
            });
        } catch (\Exception $e) {}

        try {
            Schema::table('payment_references', function (Blueprint $table) {
                DB::statement('ALTER TABLE payment_references ADD INDEX idx_payment_references_fee_year (fee_year)');
            });
        } catch (\Exception $e) {}

        try {
            Schema::table('payment_references', function (Blueprint $table) {
                DB::statement('ALTER TABLE payment_references ADD INDEX idx_payment_references_expires_at (expires_at)');
            });
        } catch (\Exception $e) {}

        try {
            Schema::table('payment_references', function (Blueprint $table) {
                DB::statement('ALTER TABLE payment_references ADD INDEX idx_payment_references_student_status (student_id, status)');
            });
        } catch (\Exception $e) {}

        try {
            Schema::table('payment_references', function (Blueprint $table) {
                DB::statement('ALTER TABLE payment_references ADD INDEX idx_payment_references_month_year (fee_month, fee_year)');
            });
        } catch (\Exception $e) {}
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            $table->dropUnique('unique_pending_payment_reference');
            $table->dropIndex('idx_payment_references_student_id');
            $table->dropIndex('idx_payment_references_status');
            $table->dropIndex('idx_payment_references_fee_year');
            $table->dropIndex('idx_payment_references_expires_at');
            $table->dropIndex('idx_payment_references_student_status');
            $table->dropIndex('idx_payment_references_month_year');
        });
    }
};
