<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('failed_reconciliations', function (Blueprint $table) {
            if (!Schema::hasColumn('failed_reconciliations', 'raw_content')) {
                $table->text('raw_content')->nullable()->after('file_name')
                    ->comment('Conteudo raw da linha do ficheiro para reprocessamento');
            }
            if (!Schema::hasColumn('failed_reconciliations', 'transaction_id')) {
                $table->string('transaction_id')->nullable()->after('reference_number');
            }
            if (!Schema::hasColumn('failed_reconciliations', 'terminal_id')) {
                $table->string('terminal_id')->nullable()->after('transaction_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('failed_reconciliations', function (Blueprint $table) {
            $table->dropColumn(['raw_content', 'transaction_id', 'terminal_id']);
        });
    }
};
