<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fee_group', function (Blueprint $table) {
            $table->decimal('amount', 10, 2)->nullable()->after('description');
            $table->text('default_description')->nullable()->after('amount');
            $table->unsignedBigInteger('parent_id')->nullable()->after('id');

            // Foreign key para subcategorias
            $table->foreign('parent_id')
                  ->references('id')
                  ->on('fee_group')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fee_group', function (Blueprint $table) {
            $table->dropForeign(['parent_id']);
            $table->dropColumn(['amount', 'default_description', 'parent_id']);
        });
    }
};
