<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            $table->timestamp('first_reminder_sent_at')->nullable()->after('expires_at');
            $table->timestamp('due_date_reminder_sent_at')->nullable()->after('first_reminder_sent_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            $table->dropColumn(['first_reminder_sent_at', 'due_date_reminder_sent_at']);
        });
    }
};
