<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('send_sms', function (Blueprint $table) {
            // Add columns if they don't exist
            if (!Schema::hasColumn('send_sms', 'description')) {
                $table->text('description')->nullable()->after('type');
            }
            if (!Schema::hasColumn('send_sms', 'created_by')) {
                $table->string('created_by')->nullable()->after('media_url');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('send_sms', function (Blueprint $table) {
            if (Schema::hasColumn('send_sms', 'description')) {
                $table->dropColumn('description');
            }
            if (Schema::hasColumn('send_sms', 'created_by')) {
                $table->dropColumn('created_by');
            }
        });
    }
};
