<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pre_enrollments', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('code')->unique();
            $table->string('status')->default('pendente');

            // Dados do Candidato
            $table->string('candidate_name');
            $table->string('candidate_sex');
            $table->date('candidate_dob');
            $table->string('candidate_phone');
            $table->string('candidate_email')->nullable();
            $table->string('candidate_address')->nullable();
            $table->string('candidate_origin')->nullable();

            // Filiacao
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('birth_place')->nullable();
            $table->string('birth_district')->nullable();
            $table->string('birth_province')->nullable();

            // Documentos
            $table->string('document_type')->nullable();
            $table->string('document_id')->nullable();

            // Ingresso
            $table->string('entry_type')->default('Normal');
            $table->string('previous_institution')->nullable();
            $table->string('previous_course')->nullable();

            // Encarregado de Educacao
            $table->string('guardian_name')->nullable();
            $table->string('guardian_relationship')->nullable();
            $table->string('guardian_phone')->nullable();
            $table->string('guardian_email')->nullable();
            $table->string('guardian_address')->nullable();

            // Academico
            $table->string('desired_class')->nullable();
            $table->string('desired_classroom_id')->nullable();
            $table->string('academic_year')->nullable();

            // Tracking
            $table->timestamp('submitted_at')->nullable();
            $table->timestamp('confirmed_at')->nullable();
            $table->timestamp('cancelled_at')->nullable();
            $table->string('cancellation_reason')->nullable();
            $table->string('registered_by')->nullable();
            $table->string('confirmed_by')->nullable();
            $table->string('enrolled_by')->nullable();
            $table->string('resulting_user_id')->nullable();
            $table->text('observation')->nullable();

            $table->softDeletes();
            $table->timestamps();

            $table->index('code');
            $table->index('status');
            $table->index('academic_year');
            $table->index('desired_class');
            $table->index('candidate_phone');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pre_enrollments');
    }
};
