/**
 * SIDEBAR OVERLAY - Mobile Toggle Fix
 * Cria overlay clicável para fechar sidebar no mobile
 */

$(document).ready(function() {
    "use strict";

    // Criar elemento de overlay se não existir
    if (!$('.sidebar-overlay').length) {
        $('body').append('<div class="sidebar-overlay"></div>');
    }

    // Função para fechar sidebar
    function closeSidebar() {
        $('body').addClass('sidebar-hidden');
    }

    // Função para abrir sidebar
    function openSidebar() {
        $('body').removeClass('sidebar-hidden');
    }

    // Click no overlay fecha o sidebar
    $(document).on('click', '.sidebar-overlay', function() {
        closeSidebar();
    });

    // Toggle do sidebar (já existe no main.min.js, mas garantimos aqui)
    $("#sidebar-toggle").on("click", function(e) {
        e.preventDefault();
        $("body").toggleClass("sidebar-hidden");
    });

    // Fechar sidebar ao clicar em link no mobile (opcional)
    if ($(window).width() < 1200) {
        $('.page-sidebar a').on('click', function() {
            // Fecha sidebar depois de clicar em um link no mobile
            setTimeout(function() {
                closeSidebar();
            }, 300);
        });
    }

    // Fechar sidebar ao pressionar ESC
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape' && $(window).width() < 1200) {
            closeSidebar();
        }
    });

    // Prevenir scroll do body quando sidebar aberto no mobile
    $(window).on('resize', function() {
        if ($(window).width() < 1200 && !$('body').hasClass('sidebar-hidden')) {
            $('body').css('overflow', 'hidden');
        } else {
            $('body').css('overflow', '');
        }
    });

    // Inicializar estado no mobile
    if ($(window).width() < 1200) {
        $('body').addClass('sidebar-hidden');
    }
});
