<?php
$class_id = '';
$mfd_count = 0;
$get_class = '';
$subjects_get = [];
$showThirdTrimesterColumns = false; // Inicializa a variável

// Carregar disciplinas e classes apenas uma vez para evitar duplicação
foreach ($models as $model) {
    $classroom = \App\Models\Classroom::find($model->classroom_id);
    if ($classroom) {
        $get_class = $classroom->class ?? 0;
        
        // Verifica se é o terceiro trimestre
                if ($model->trimester_id == 3) {
                    $showThirdTrimesterColumns = true;
                }


        // Carregar disciplinas relacionadas
        $query_subjects = \App\Models\TeacherSubject::where('classroom_id', $model->classroom_id)->pluck('subject_id');
        $subjects = \App\Models\Subject::whereIn('id', $query_subjects)->pluck('name', 'id')->toArray();

        $subjects_get = array_merge($subjects_get, $subjects);
    }

    $class_id = $get_class;
    if ($get_class != 0) {
        break;
    }
}

// Ordenar disciplinas por ordem alfabética
ksort($subjects_get);

// Sistema customizado: buscar disciplinas com NE/AF da configuração dinâmica
$year = $model->year ?? date('Y');
$ne_subjects3 = \App\Models\ExamConfiguration::getSubjectsWithExam(3, null, $year);
$ne_subjects6 = \App\Models\ExamConfiguration::getSubjectsWithExam(6, 'NE', $year);
$ne_subjects9 = \App\Models\ExamConfiguration::getSubjectsWithExam(9, 'NE', $year);
$ne_subjects = \App\Models\ExamConfiguration::getSubjectsWithExam(10, 'NE', $year); // Para 10ª e 12ª classes

$subjects = $subjects_get;
$divide = count($subjects);

/**
 * Função para calcular valores de trimestre
 */
function getTrimesterValues($student_id, $classroom_id, $subject_id, $trimester_id)
{
    static $exam_cache = [];

    $key = "{$student_id}_{$classroom_id}_{$subject_id}_{$trimester_id}";
    if (!isset($exam_cache[$key])) {
        $exam = \App\Models\Exam::where([
            ['trimester_id', $trimester_id],
            ['classroom_id', $classroom_id],
            ['subject_id', $subject_id],
            ['student_id', $student_id],
        ])->first();

        $exam_cache[$key] = [
            (float) ($exam->ACS1a ?? 0),
            (float) ($exam->ACS2a ?? 0),
            (float) ($exam->AT ?? 0),
            (float) ($exam->NE ?? 0),
        ];
    }

    return $exam_cache[$key];
}
?>

<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:poll.keep-alive>
                            <h5 class="card-title">Notas do estudante</h5>
                            <div class="row">
                                <div class="col-md-12"></div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive" wire:init="loadData">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th colspan="4"></th>
                                                    <?php foreach ($subjects as $key => $name): ?>
                                                        <?php
                                                        // Determinar qual array de disciplinas usar baseado na classe
                                                        $current_ne_subjects = $ne_subjects; // Default
                                                        if ($class_id == 3) {
                                                            $current_ne_subjects = $ne_subjects3;
                                                        } elseif ($class_id == 6) {
                                                            $current_ne_subjects = $ne_subjects6;
                                                        } elseif ($class_id == 9) {
                                                            $current_ne_subjects = $ne_subjects9;
                                                        }

                                                        if ($class_id == 3 || $class_id == 6 || $class_id == 9 || $class_id == 10 || $class_id == 12): ?>
                                                            <th colspan="<?= ($showThirdTrimesterColumns && in_array($name, $current_ne_subjects)) ? 6 : 5 ?>" style="border: 1px solid #000; text-align: center;">
                                                                <?= $name ?>
                                                            </th>
                                                        <?php else: ?>
                                                            <th colspan="5" style="border: 1px solid #000; text-align: center;">
                                                                <?= $name ?>
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </tr>
                                                <tr>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">#</th>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">Nome Completo</th>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">ID do Estudante</th>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">Sexo</th>
                                                    <?php foreach ($subjects as $key => $name): ?>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">ACS1</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">ACS2</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">MACS</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">AT</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">MT</th>
                                                        <?php if ($showThirdTrimesterColumns && in_array($name, $current_ne_subjects)): ?>
                                                            <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">
                                                                <?= $class_id == 3 ? 'AF' : 'NE' ?>
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">MFD</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php($count = 1)
                                                @foreach ($models as $model)
                                                    <?php $mfd_count = 0; ?>
                                                    <tr>
                                                        <th>{{ $count++ }}</th>
                                                        <td>{{ $model->student->name }}</td>
                                                        <td>{{ $model->student->student_id }}</td>
                                                        <td>{{ $model->student->sex }}</td>

                                                        <?php foreach ($subjects as $key => $name): ?>
                                                        <?php
                                                        // Determinar qual array de disciplinas usar baseado na classe
                                                        $current_ne_subjects = $ne_subjects; // Default
                                                        if ($class_id == 3) {
                                                            $current_ne_subjects = $ne_subjects3;
                                                        } elseif ($class_id == 6) {
                                                            $current_ne_subjects = $ne_subjects6;
                                                        } elseif ($class_id == 9) {
                                                            $current_ne_subjects = $ne_subjects9;
                                                        }

                                                        // Use o trimestre atual da exportação em vez de sempre o trimestre 1
                                                        $current_trim = getTrimesterValues($model->student_id, $model->classroom_id, $key, $model->trimester_id);
                                                        $trim1 = getTrimesterValues($model->student_id, $model->classroom_id, $key, 1);
                                                        $trim2 = getTrimesterValues($model->student_id, $model->classroom_id, $key, 2);
                                                        $trim3 = getTrimesterValues($model->student_id, $model->classroom_id, $key, 3);

                                                        $acs1 = $current_trim[0];
                                                        $acs2 = $current_trim[1];
                                                        $macs = round(($acs1 + $acs2) / 2, 2);
                                                        $at = $current_trim[2];
                                                        $mt = round(($acs1 + $acs2 + $at) / 3, 2);
                                                        $ne = $trim3[3];

                                                        // Calcular MT de cada trimestre
                                                        $mt1 = round(($trim1[0] + $trim1[1] + $trim1[2]) / 3, 2);
                                                        $mt2 = round(($trim2[0] + $trim2[1] + $trim2[2]) / 3, 2);
                                                        $mt3 = round(($trim3[0] + $trim3[1] + $trim3[2]) / 3, 2);

                                                        // MFD = média dos MT dos 3 trimestres
                                                        $mfd = round(($mt1 + $mt2 + $mt3) / 3, 2);

                                                        // Nota final (com ou sem NE)
                                                        $final = in_array($name, $current_ne_subjects) && $showThirdTrimesterColumns
                                                            ? round(($mfd * 2 + $ne) / 3, 2)
                                                            : $mfd;

                                                        $mfd_count += $final;
                                                        ?>
                                                        <td>{{ number_format($acs1, 2) }}</td>
                                                        <td>{{ number_format($acs2, 2) }}</td>
                                                        <td>{{ number_format($macs, 2) }}</td>
                                                        <td>{{ number_format($at, 2) }}</td>
                                                        <td>{{ round($mt) }}</td>
                                                        <?php if ($showThirdTrimesterColumns && in_array($name, $current_ne_subjects)): ?>
                                                            <td>{{ number_format($ne, 2) }}</td>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    
                                                    <td>
                                                        {{ $divide > 0 ? round($mfd_count / $divide) : '0' }}
                                                    </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


