<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', '') }}</title>
    <link rel="icon" type="image/png" href="{{ asset('assets/images/logo.png') }}">
    <link rel="shortcut icon" href="{{ asset('assets/images/logo.png') }}" type="image/x-icon">

    <meta name="author" content="">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ config('app.name') }}" />
    <meta property="og:image" content="{{ asset('assets/images/logo.png') }}" />
    <meta property="og:description" content="" />

    <!-- Styles -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&display=swap" rel="stylesheet">
    <link href="{{ asset('assets/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/font-awesome/css/all.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="{{ asset('assets/plugins/perfectscroll/perfect-scrollbar.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/apexcharts/apexcharts.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/DataTables/datatables.min.css') }}" rel="stylesheet">

    <!-- Theme Styles -->
    <link href="{{ asset('assets/css/main.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/custom.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/sidebar-toggle-fix.css') }}" rel="stylesheet">
    @livewireStyles
    @trixassets
    <style>
        .footer-text-left {
            font-size: 15px;
            padding-left: 500px;
            float: center;
            word-spacing: 20px;
        }
    </style>
</head>

<body>
    <div class='loader' wire:loading>
        <div class='spinner-grow text-primary' role='status'>
            <span class='sr-only'>Processando...</span>
        </div>
    </div>



    <div class="page-container">
        @if (Auth::guard('admin')->check())
            <livewire:admin.inc.header />
            <livewire:admin.inc.sidebar />
        @elseif (Auth::guard('guardian')->check())
            <livewire:guardian.inc.header />
            <livewire:guardian.inc.sidebar />
        @elseif (Auth::guard('web')->check())
            <livewire:user.inc.header />
            <livewire:user.inc.sidebar />
        @endif
        {{ $slot }}
        <div class="container">
            <div class="row">
                <div class="col-md-2"></div>
                     </div>
                </div>
                <div class="col-md-2"></div>
            </div>

        </div>

        <footer style="text-align:center; padding:20px 0 10px; color:#6c757d; font-size:13px;">
            &copy; {{ date('Y') }} {{ config('app.name') }} - Desenvolvido por <a href="https://www.ifix.co.mz" target="_blank" style="color:#058fd0; text-decoration:none;">iFix, Lda</a>
        </footer>

    </div>

    <!-- Javascripts -->
    <script src="{{ asset('assets/plugins/jquery/jquery-3.4.1.min.js') }}"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.min.js') }}"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <script src="{{ asset('assets/plugins/perfectscroll/perfect-scrollbar.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/apexcharts/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/js/main.min.js') }}"></script>
    <script src="{{ asset('assets/js/pages/dashboard.js') }}"></script>
    <script src="{{ asset('assets/js/pages/datatables.js') }}"></script>
    <script src="{{ asset('assets/plugins/DataTables/datatables.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    @yield('scripts')
    <script src="{{ asset('assets/js/sweetalert.js') }}"></script>
    <x-livewire-alert::scripts />
    @livewireScripts
</body>

</html>
