<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0">Relatório de Presença</h5>
                                @if($classroom_id)
                                    <a href="{{ route('admin.attendance.pdf', ['classroom_id' => $classroom_id, 'from' => $date_from, 'to' => $date_to, 'year' => $year]) }}"
                                       class="btn btn-sm btn-outline-danger" target="_blank">
                                        <i class="fas fa-file-pdf me-1"></i> Baixar PDF
                                    </a>
                                @endif
                            </div>

                            <!-- Filters -->
                            <div class="row mb-4">
                                <div class="col-md-2">
                                    <label class="form-label">Ano</label>
                                    <select class="form-control" wire:model="year">
                                        @php $currentYear = (int)date('Y'); @endphp
                                        @for($y = $currentYear; $y >= 2023; $y--)
                                            <option value="{{ $y }}">{{ $y }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Turma</label>
                                    <select class="form-control" wire:model="classroom_id">
                                        <option value="">Selecione a turma</option>
                                        @foreach ($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->class }}ª - {{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">De</label>
                                    <input type="date" class="form-control" wire:model="date_from">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Até</label>
                                    <input type="date" class="form-control" wire:model="date_to">
                                </div>
                            </div>

                            @if(!$readyToLoad)
                                <div class="text-center py-4">
                                    <div class="spinner-border text-primary" role="status"></div>
                                    <p class="mt-2 text-muted">A carregar...</p>
                                </div>
                            @elseif($classroom_id)
                                <!-- Summary Cards -->
                                <div class="row mb-4">
                                    <div class="col-md-2">
                                        <div class="card border-primary">
                                            <div class="card-body text-center p-3">
                                                <h6 class="text-muted mb-1">Dias</h6>
                                                <h3 class="mb-0 text-primary">{{ $summary['total_days'] }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-success">
                                            <div class="card-body text-center p-3">
                                                <h6 class="text-muted mb-1">Presentes</h6>
                                                <h3 class="mb-0 text-success">{{ $summary['total_present'] }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-danger">
                                            <div class="card-body text-center p-3">
                                                <h6 class="text-muted mb-1">Ausentes</h6>
                                                <h3 class="mb-0 text-danger">{{ $summary['total_absent'] }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-warning">
                                            <div class="card-body text-center p-3">
                                                <h6 class="text-muted mb-1">Atrasados</h6>
                                                <h3 class="mb-0 text-warning">{{ $summary['total_late'] }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-info">
                                            <div class="card-body text-center p-3">
                                                <h6 class="text-muted mb-1">Justificados</h6>
                                                <h3 class="mb-0 text-info">{{ $summary['total_justified'] }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-dark">
                                            <div class="card-body text-center p-3">
                                                <h6 class="text-muted mb-1">Taxa</h6>
                                                <h3 class="mb-0">{{ $summary['rate'] }}%</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Per-Student Breakdown -->
                                @if($studentBreakdown->count() > 0)
                                    <h6 class="mb-3">Detalhes por Estudante</h6>
                                    <div class="table-responsive">
                                        <table class="table table-hover table-bordered">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>Nome</th>
                                                    <th class="text-center">Total</th>
                                                    <th class="text-center">Presente</th>
                                                    <th class="text-center">Ausente</th>
                                                    <th class="text-center">Atrasado</th>
                                                    <th class="text-center">Justificado</th>
                                                    <th class="text-center">Taxa %</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($studentBreakdown as $index => $s)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $s['name'] }}</td>
                                                        <td class="text-center">{{ $s['total'] }}</td>
                                                        <td class="text-center text-success">{{ $s['present'] }}</td>
                                                        <td class="text-center text-danger">{{ $s['absent'] }}</td>
                                                        <td class="text-center text-warning">{{ $s['late'] }}</td>
                                                        <td class="text-center text-info">{{ $s['justified'] }}</td>
                                                        <td class="text-center">
                                                            <span class="badge {{ $s['rate'] >= 75 ? 'bg-success' : ($s['rate'] >= 50 ? 'bg-warning text-dark' : 'bg-danger') }}">
                                                                {{ $s['rate'] }}%
                                                            </span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-1"></i> Nenhum registo de presença encontrado para o período seleccionado.
                                    </div>
                                @endif
                            @else
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-1"></i> Selecione uma turma para ver o relatório.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
