<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-door-open me-2"></i>
                        Adicionar Turma
                    </h2>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <!-- Nome da Turma -->
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label fw-semibold">Nome da Turma <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-tag"></i></span>
                                        <input type="text"
                                               id="name"
                                               wire:model="name"
                                               class="form-control @error('name') is-invalid @enderror"
                                               placeholder="Ex: Turma A"
                                               required>
                                    </div>
                                    @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Classe -->
                                <div class="form-group mb-3">
                                    <label for="class" class="form-label fw-semibold">Classe <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-layer-group"></i></span>
                                        <select id="class"
                                                wire:model="class"
                                                class="form-select @error('class') is-invalid @enderror"
                                                required>
                                            <option value="">Selecione a classe...</option>
                                            @for($i = 1; $i <= 12; $i++)
                                                <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                            @endfor
                                        </select>
                                    </div>
                                    @error('class') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Capacidade Máxima -->
                                <div class="form-group mb-3">
                                    <label for="capacity" class="form-label fw-semibold">Capacidade Máxima <span class="text-muted small fw-normal">(opcional)</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                        <input type="number" id="capacity" wire:model="capacity"
                                               class="form-control @error('capacity') is-invalid @enderror"
                                               placeholder="Ex: 30" min="1" max="200">
                                    </div>
                                    @error('capacity') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Descrição -->
                                <div class="form-group mb-4" wire:model.debounce.365ms="description" wire:ignore>
                                    <label for="description" class="form-label fw-semibold">Descrição</label>
                                    <input id="description"
                                           value="{{ $description }}"
                                           type="hidden"
                                           name="description">
                                    <trix-editor input="description" class="trix-content"></trix-editor>
                                    @error('description') <span class="text-danger small d-block">{{ $message }}</span> @enderror
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }

        /* Trix Editor Styling */
        trix-editor {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            padding: 0.75rem;
            min-height: 150px;
        }

        trix-editor:focus {
            border-color: #80bdff;
            outline: none;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        trix-toolbar .trix-button-group {
            margin-bottom: 10px;
        }
    </style>
</div>
