<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h4 class="mb-1">
                                        <i class="fas fa-users-cog text-primary me-2"></i>
                                        Passagem de Classe
                                    </h4>
                                    <p class="text-muted mb-0">
                                        <strong>{{ $model->class }}ª Classe</strong> - {{ $model->name }}
                                    </p>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary fs-6 px-3 py-2">
                                        <i class="fas fa-user-graduate me-1"></i>
                                        {{ count($models) }} Estudantes
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Form -->
            <form wire:submit.prevent="updateStudent">
                <div class="row g-4">
                    <!-- Left Column - Filters -->
                    <div class="col-lg-4">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-gradient bg-primary text-white">
                                <h6 class="mb-0">
                                    <i class="fas fa-filter me-2"></i>
                                    Configurações da Passagem
                                </h6>
                            </div>
                            <div class="card-body">
                                <!-- Ano de Origem -->
                                <div class="mb-4">
                                    <label class="form-label fw-semibold">
                                        <i class="fas fa-calendar-check text-info me-2"></i>
                                        Ano Atual (Origem)
                                    </label>
                                    <select class="form-select form-select-lg" wire:model="year">
                                        <option value="">Selecione o ano</option>
                                        @foreach($years as $yearOption)
                                            <option value="{{ $yearOption }}">{{ $yearOption }}</option>
                                        @endforeach
                                    </select>
                                    <small class="text-muted">Filtra estudantes do ano selecionado</small>
                                    @error('year')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Turma de Destino -->
                                <div class="mb-4">
                                    <label class="form-label fw-semibold">
                                        <i class="fas fa-exchange-alt text-success me-2"></i>
                                        Passar Para (Turma Destino)
                                    </label>
                                    <select class="form-select form-select-lg" wire:model="classroom1">
                                        <option value="">Selecione a turma</option>
                                        @foreach($classroom as $class)
                                            <option value="{{ $class->id }}">
                                                {{ $class->class }}ª Classe - {{ $class->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="text-muted">Nova turma dos estudantes</small>
                                </div>

                                <!-- Ano de Destino -->
                                <div class="mb-4">
                                    <label class="form-label fw-semibold">
                                        <i class="fas fa-calendar-plus text-warning me-2"></i>
                                        Novo Ano Letivo (Destino)
                                    </label>
                                    <select class="form-select form-select-lg" wire:model="year_edu" required>
                                        <option value="">Selecione o ano</option>
                                        <option value="{{ date('Y') }}">{{ date('Y') }}</option>
                                        <option value="{{ date('Y') + 1 }}">{{ date('Y') + 1 }}</option>
                                    </select>
                                    <small class="text-muted">Ano letivo de destino</small>
                                    @error('year_edu')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Status do Estudante -->
                                <div class="mb-4">
                                    <label class="form-label fw-semibold d-block mb-3">
                                        <i class="fas fa-clipboard-check text-primary me-2"></i>
                                        Status da Passagem
                                    </label>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="classstatus"
                                               wire:model="classstatus" value="passed" id="statusPassed">
                                        <label class="form-check-label" for="statusPassed">
                                            <i class="fas fa-check-circle text-success me-1"></i>
                                            Aprovado
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="classstatus"
                                               wire:model="classstatus" value="failed" id="statusFailed">
                                        <label class="form-check-label" for="statusFailed">
                                            <i class="fas fa-times-circle text-danger me-1"></i>
                                            Reprovado
                                        </label>
                                    </div>
                                </div>

                                <hr class="my-4">

                                <!-- Action Button -->
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:target="updateStudent">
                                        <i class="fas fa-save me-2" wire:loading.remove wire:target="updateStudent"></i>
                                        <i class="fas fa-spinner fa-spin me-2" wire:loading wire:target="updateStudent"></i>
                                        <span wire:loading.remove wire:target="updateStudent">Confirmar Passagem de Classe</span>
                                        <span wire:loading wire:target="updateStudent">Processando...</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column - Students List -->
                    <div class="col-lg-8">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-light border-bottom">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="mb-0">
                                        <i class="fas fa-list-ul me-2"></i>
                                        Selecione os Estudantes
                                    </h6>
                                    @if(count($models) > 0)
                                        <small class="text-muted">
                                            <i class="fas fa-info-circle me-1"></i>
                                            Use Ctrl/Cmd para seleção múltipla
                                        </small>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body p-0">
                                @if(count($models) > 0)
                                    <select class="form-select border-0 rounded-0"
                                            multiple
                                            wire:model="studentid"
                                            size="25"
                                            style="font-size: 1rem;">
                                        @foreach($models as $model)
                                            <option value="{{ $model->id }}"
                                                    class="py-2 px-3"
                                                    style="border-bottom: 1px solid #f0f0f0;">
                                                <i class="fas fa-user me-2"></i>
                                                {{ $model->name }}
                                                @if($model->year_edu == date('Y'))
                                                    <span class="badge bg-success ms-2">✓ Promovido</span>
                                                @else
                                                    <span class="badge bg-warning ms-2">⚠ Não Promovido</span>
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                @else
                                    <div class="text-center py-5">
                                        <div wire:loading class="mb-3">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Carregando...</span>
                                            </div>
                                        </div>
                                        <div wire:loading.remove>
                                            <i class="fas fa-user-slash fa-3x text-muted mb-3"></i>
                                            <p class="text-muted mb-0">
                                                <strong>Nenhum estudante encontrado</strong>
                                            </p>
                                            <small class="text-muted">
                                                Selecione um ano para visualizar os estudantes
                                            </small>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            @if(count($models) > 0)
                                <div class="card-footer bg-light border-top">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">
                                            <i class="fas fa-users me-1"></i>
                                            Total de estudantes disponíveis: <strong>{{ count($models) }}</strong>
                                        </small>
                                        <small class="text-muted" wire:loading.remove wire:target="year">
                                            <i class="fas fa-clock me-1"></i>
                                            Atualizado em {{ now()->format('d/m/Y H:i') }}
                                        </small>
                                        <small class="text-primary" wire:loading wire:target="year">
                                            <i class="fas fa-sync fa-spin me-1"></i>
                                            Atualizando lista...
                                        </small>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </form>

            <!-- Info Alert -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="alert alert-info border-0 shadow-sm">
                        <div class="d-flex">
                            <div class="me-3">
                                <i class="fas fa-info-circle fa-2x"></i>
                            </div>
                            <div>
                                <h6 class="alert-heading mb-2">Como funciona a Passagem de Classe?</h6>
                                <ul class="mb-0 small">
                                    <li>Selecione o <strong>ano atual</strong> para filtrar os estudantes</li>
                                    <li>Escolha a <strong>turma de destino</strong> para onde os estudantes serão transferidos</li>
                                    <li>Defina o <strong>novo ano letivo</strong> (geralmente o próximo ano)</li>
                                    <li>Marque os estudantes na lista usando <kbd>Ctrl</kbd> ou <kbd>Cmd</kbd> para seleção múltipla</li>
                                    <li>Clique em "Confirmar Passagem de Classe" para concluir</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-select option {
            padding: 10px;
        }

        .form-select[multiple] option:hover {
            background-color: #e3f2fd !important;
        }

        .form-select[multiple] option:checked {
            background-color: #1976d2 !important;
            color: white !important;
        }

        .bg-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .card {
            transition: transform 0.2s ease-in-out;
        }

        .card:hover {
            transform: translateY(-2px);
        }

        .btn-primary {
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 123, 255, 0.3);
        }
    </style>
</div>
