<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card border-0 shadow">
                        <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-edit me-2"></i>Editar Matriz
                            </h2>
                            <a href="{{ route('admin.downloads') }}" class="btn btn-sm btn-light">
                                <i class="fas fa-arrow-left me-1"></i>Voltar
                            </a>
                        </div>
                        <div class="card-body p-4">
                            <div class="row justify-content-center">
                                <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                                    <form wire:submit.prevent="submit">
                                        <div class="mb-3">
                                            <label for="title" class="form-label fw-semibold">Título <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                                <input type="text"
                                                       class="form-control @error('title') is-invalid @enderror"
                                                       id="title"
                                                       wire:model="title"
                                                       placeholder="Insira o título..."
                                                       required>
                                            </div>
                                            @error('title')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="author" class="form-label fw-semibold">Autor <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-user"></i></span>
                                                <input type="text"
                                                       class="form-control @error('author') is-invalid @enderror"
                                                       id="author"
                                                       wire:model="author"
                                                       placeholder="Insira o autor..."
                                                       required>
                                            </div>
                                            @error('author')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="description" class="form-label fw-semibold">Descrição</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-align-left"></i></span>
                                                <textarea class="form-control @error('description') is-invalid @enderror"
                                                          wire:model="description"
                                                          id="description"
                                                          rows="3"
                                                          placeholder="Insira a descrição..."></textarea>
                                            </div>
                                            @error('description')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="photo" class="form-label fw-semibold">Ficheiro</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-file-upload"></i></span>
                                                <input type="file"
                                                       class="form-control @error('photo') is-invalid @enderror"
                                                       wire:model="photo"
                                                       id="photo">
                                            </div>
                                            <small class="text-muted">
                                                <i class="fas fa-info-circle me-1"></i>
                                                Deixe em branco para manter o ficheiro atual
                                            </small>
                                            @error('photo')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                            <div wire:loading wire:target="photo" class="mt-2">
                                                <small class="text-primary">
                                                    <span class="spinner-border spinner-border-sm me-1"></span>
                                                    Carregando ficheiro...
                                                </small>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-between border-top pt-4 mt-4">
                                            <a href="{{ route('admin.downloads') }}" class="btn btn-outline-secondary px-4">
                                                <i class="fas fa-times me-2"></i>Cancelar
                                            </a>

                                            <button type="submit"
                                                    class="btn btn-primary px-4"
                                                    wire:loading.attr="disabled"
                                                    wire:offline.attr="disabled">
                                                <span wire:loading wire:target="submit" class="spinner-border spinner-border-sm me-2"></span>
                                                <i wire:loading.remove wire:target="submit" class="fas fa-save me-2"></i>
                                                Atualizar Matriz
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
