{{-- resources/views/livewire/admin/fee/generate-references.blade.php --}}
<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header -->
            <div class="row mb-4">
                <div class="col">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h4 class="card-title mb-1">
                                        <i class="fas fa-receipt text-primary me-2"></i>
                                        Geração de Referências de Pagamento
                                    </h4>
                                    <p class="text-muted mb-0">Gere referências individuais ou por turma</p>
                                </div>
                                <div>
                                    <button wire:click="$refresh" class="btn btn-outline-primary">
                                        <i class="fas fa-sync-alt"></i> Atualizar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="row mb-4">
                <div class="col-md-3 mb-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-circle d-flex align-items-center justify-content-center"
                                         style="width: 60px; height: 60px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                        <i class="fas fa-file-alt" style="font-size: 24px; color: #fff;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 fw-normal">Total Geradas</h6>
                                    <h2 class="mb-0 fw-bold">{{ $stats['total_generated'] }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3 mb-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-circle d-flex align-items-center justify-content-center"
                                         style="width: 60px; height: 60px; background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                                        <i class="fas fa-clock" style="font-size: 24px; color: #fff;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 fw-normal">Pendentes</h6>
                                    <h2 class="mb-0 fw-bold">{{ $stats['total_pending'] }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3 mb-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-circle d-flex align-items-center justify-content-center"
                                         style="width: 60px; height: 60px; background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                                        <i class="fas fa-check-circle" style="font-size: 24px; color: #fff;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 fw-normal">Pagas</h6>
                                    <h2 class="mb-0 fw-bold text-success">{{ $stats['total_paid'] }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3 mb-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-circle d-flex align-items-center justify-content-center"
                                         style="width: 60px; height: 60px; background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                                        <i class="fas fa-exclamation-triangle" style="font-size: 24px; color: #fff;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 fw-normal">Expiradas</h6>
                                    <h2 class="mb-0 fw-bold text-danger">{{ $stats['total_expired'] }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="row">
                <!-- Left Column - Generation Form -->
                <div class="col-lg-8 mb-4">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom">
                            <h5 class="mb-0">Gerar Nova Referência</h5>
                        </div>
                        <div class="card-body">
                            <!-- Mode Selection -->
                            <div class="mb-4">
                                <label class="form-label fw-bold">Modo de Geração</label>
                                <div class="btn-group w-100" role="group">
                                    <input type="radio" class="btn-check" wire:model="generationMode" value="individual" id="mode-individual" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="mode-individual">
                                        <i class="fas fa-user me-2"></i>Individual
                                    </label>

                                    <input type="radio" class="btn-check" wire:model="generationMode" value="class" id="mode-class" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="mode-class">
                                        <i class="fas fa-users me-2"></i>Por Turma
                                    </label>

                                    <input type="radio" class="btn-check" wire:model="generationMode" value="import" id="mode-import" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="mode-import">
                                        <i class="fas fa-file-excel me-2"></i>Importar Excel
                                    </label>
                                </div>
                            </div>

                            <!-- Individual Mode -->
                            @if($generationMode === 'individual')
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Buscar Estudante *</label>
                                    <div class="position-relative">
                                        <input type="text"
                                               wire:model.debounce.300ms="searchTerm"
                                               class="form-control"
                                               placeholder="Digite o nome, código ou email do estudante...">
                                        <i class="fas fa-search position-absolute top-50 end-0 translate-middle-y me-3 text-muted"></i>
                                    </div>
                                    @error('selectedStudentId') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                                    @if($searchResults && $searchResults->count() > 0 && !$selectedStudentId)
                                        <div class="list-group mt-2">
                                            @foreach($searchResults as $student)
                                                <button type="button"
                                                        wire:click="selectStudent('{{ $student->id }}')"
                                                        class="list-group-item list-group-item-action">
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2">
                                                            {{ strtoupper(substr($student->name, 0, 1)) }}
                                                        </div>
                                                        <div>
                                                            <strong>{{ $student->name }}</strong><br>
                                                            <small class="text-muted">
                                                                Código: {{ $student->student_id }} | Email: {{ $student->email ?? 'N/A' }}
                                                            </small>
                                                        </div>
                                                    </div>
                                                </button>
                                            @endforeach
                                        </div>
                                    @endif

                                    @if($selectedStudentId)
                                        @php
                                            $studentData = \App\Models\User::find($selectedStudentId);
                                        @endphp
                                        @if($studentData)
                                        <div class="alert alert-info mt-2 d-flex align-items-center justify-content-between">
                                            <div>
                                                <i class="fas fa-user-check me-2"></i>
                                                <strong>{{ $studentData->name }}</strong> - {{ $studentData->student_id }}
                                            </div>
                                            <button type="button" wire:click="$set('selectedStudentId', null)" class="btn btn-sm btn-outline-secondary">
                                                <i class="fas fa-times"></i> Limpar
                                            </button>
                                        </div>
                                        @endif
                                    @endif
                                </div>
                            @endif

                            <!-- Class Mode (Seleção em Cascata) -->
                            @if($generationMode === 'class')
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">Classe *</label>
                                        <select wire:model.live="selectedClass" class="form-select">
                                            <option value="">-- Selecione a classe --</option>
                                            @foreach($availableClasses as $class)
                                                <option value="{{ $class }}">{{ $class }}ª Classe</option>
                                            @endforeach
                                        </select>
                                        @error('selectedClass') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">Turma *</label>
                                        <select wire:model.live="selectedTurma" class="form-select" {{ !$selectedClass || $selectAllTurmas ? 'disabled' : '' }}>
                                            <option value="">-- Selecione a turma --</option>
                                            @if($availableTurmas)
                                                @foreach($availableTurmas as $turma)
                                                    <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                        @error('selectedTurma') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                                        @if($selectedClass && $availableTurmas && count($availableTurmas) > 1)
                                            <div class="form-check mt-2">
                                                <input class="form-check-input" type="checkbox"
                                                       wire:model.live="selectAllTurmas"
                                                       id="selectAllTurmas">
                                                <label class="form-check-label" for="selectAllTurmas">
                                                    <i class="fas fa-users"></i> Todas as turmas desta classe
                                                    @if($selectAllTurmas && !empty($classroomStudents))
                                                        <span class="badge bg-primary ms-1">{{ count($classroomStudents) }} estudantes</span>
                                                    @endif
                                                </label>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                @if(!empty($classroomStudents) && count($classroomStudents) > 0)
                                    <div class="alert alert-info mb-3">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>{{ count($classroomStudents) }}</strong> estudantes serão processados
                                    </div>
                                @endif
                            @endif

                            <!-- Import Mode -->
                            @if($generationMode === 'import')
                                <div class="mb-3">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Importação em Lote</strong><br>
                                        <small>Faça upload de um arquivo Excel com os dados dos estudantes (código, valor, descrição).</small>
                                    </div>

                                    <div class="mb-3">
                                        <button wire:click="downloadTemplate" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-download me-1"></i> Baixar Template Excel
                                        </button>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Arquivo Excel *</label>
                                        <input type="file" wire:model="importFile" class="form-control" accept=".xlsx,.xls,.csv">
                                        @error('importFile') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                                        <small class="text-muted">
                                            Formato aceito: Excel (.xlsx, .xls) ou CSV. Máximo 10MB.
                                        </small>
                                    </div>

                                    @if($importFile)
                                        <div class="alert alert-success">
                                            <i class="fas fa-check-circle me-2"></i>
                                            Arquivo selecionado: <strong>{{ $importFile->getClientOriginalName() }}</strong>
                                        </div>
                                    @endif

                                    @if($importResults)
                                        <div class="alert alert-{{ $importResults['errors'] > 0 ? 'warning' : 'success' }}">
                                            <strong>Resultado da Importação:</strong><br>
                                            ✓ {{ $importResults['success'] }} referências criadas<br>
                                            @if($importResults['errors'] > 0)
                                                ✗ {{ $importResults['errors'] }} erros encontrados
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            @endif

                            @if($generationMode !== 'import')
                                <hr class="my-4">

                                <!-- Payment Details -->
                                <h6 class="fw-bold mb-3">Detalhes do Pagamento</h6>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Tipo de Taxa *</label>
                                    <div class="mb-2">
                                        <div class="btn-group btn-group-sm w-100" role="group">
                                            <input type="radio" class="btn-check" wire:model="feeTypeMode" value="predefined" id="feeTypeMode-predefined" autocomplete="off">
                                            <label class="btn btn-outline-secondary" for="feeTypeMode-predefined">
                                                <i class="fas fa-list me-1"></i>Selecionar
                                            </label>
                                            <input type="radio" class="btn-check" wire:model="feeTypeMode" value="custom" id="feeTypeMode-custom" autocomplete="off">
                                            <label class="btn btn-outline-secondary" for="feeTypeMode-custom">
                                                <i class="fas fa-keyboard me-1"></i>Escrever Manual
                                            </label>
                                        </div>
                                    </div>

                                    @if($feeTypeMode === 'predefined')
                                        <select wire:model="selectedFeeType" class="form-select">
                                            <option value="">-- Selecione uma categoria --</option>

                                            {{-- Opção especial: POS --}}
                                            <optgroup label="🛒 POS (Ponto de Venda)">
                                                <option value="pos">Venda de Produto POS</option>
                                            </optgroup>

                                            {{-- Categorias de Taxas (FeeGroup) agrupadas por categoria pai --}}
                                            @foreach($feeGroupsGrouped as $groupName => $feeGroupsInGroup)
                                                <optgroup label="📁 {{ $groupName }}">
                                                    @foreach($feeGroupsInGroup as $feeGroup)
                                                        <option value="{{ $feeGroup->id }}">
                                                            {{ $feeGroup->name }}
                                                            @if($feeGroup->amount)
                                                                - {{ number_format($feeGroup->amount, 2) }} MT
                                                            @endif
                                                            @if($feeGroup->fine_type === 'percentage' && $feeGroup->percentage)
                                                                (Multa: {{ number_format($feeGroup->percentage, 1) }}%)
                                                            @elseif($feeGroup->fine_type === 'fixed' && $feeGroup->fixed_amount)
                                                                (Multa: {{ number_format($feeGroup->fixed_amount, 2) }} MT)
                                                            @endif
                                                        </option>
                                                    @endforeach
                                                </optgroup>
                                            @endforeach
                                        </select>
                                        @error('selectedFeeType') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                                        {{-- Dropdown adicional quando selecionar POS --}}
                                        @if($selectedFeeType === 'pos')
                                            <div class="mt-2">
                                                <label class="form-label small">Produto POS *</label>
                                                <select wire:model="selectedPosProduct" class="form-select">
                                                    <option value="">-- Selecione o produto --</option>
                                                    @foreach($posProducts as $product)
                                                        <option value="{{ $product->id }}">
                                                            {{ $product->name }} - {{ number_format($product->price, 2) }} MT
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('selectedPosProduct') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                            </div>
                                        @endif
                                    @else
                                        <input type="text"
                                               wire:model="customFeeTypeName"
                                               class="form-control"
                                               placeholder="Ex: Mensalidade, Propina, Material Escolar...">
                                        @error('customFeeTypeName') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                    @endif
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Valor (MT) *</label>
                                    <input type="number" wire:model="amount" step="0.01" min="1" class="form-control" placeholder="0.00" {{ $selectedFeeType === 'pos' && $selectedPosProduct ? 'readonly' : '' }}>
                                    @error('amount') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" wire:model="isMonthly" id="isMonthly">
                                        <label class="form-check-label small fw-semibold" for="isMonthly">Pagamento mensal?</label>
                                    </div>
                                    @if($isMonthly)
                                    <select wire:model="feeMonth" class="form-select">
                                        <option value="january">Janeiro</option>
                                        <option value="february">Fevereiro</option>
                                        <option value="march">Março</option>
                                        <option value="april">Abril</option>
                                        <option value="may">Maio</option>
                                        <option value="june">Junho</option>
                                        <option value="july">Julho</option>
                                        <option value="august">Agosto</option>
                                        <option value="september">Setembro</option>
                                        <option value="october">Outubro</option>
                                        <option value="november">Novembro</option>
                                        <option value="december">Dezembro</option>
                                    </select>
                                    @error('feeMonth') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                    @else
                                    <div class="form-control bg-light text-muted" style="pointer-events:none">Pagamento anual / único</div>
                                    @endif
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Ano *</label>
                                    <input type="number" wire:model="feeYear" min="2020" max="2100" class="form-control">
                                    @error('feeYear') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>

                            </div>

                            <hr class="my-4">

                            <!-- Alerta sobre Prazo de Geração -->
                            @if($deadlineMessage)
                                <div class="alert {{ $canGenerate ? 'alert-info' : 'alert-danger' }} mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div>
                                            <i class="fas {{ $canGenerate ? 'fa-info-circle' : 'fa-exclamation-triangle' }} me-2"></i>
                                            <strong>Prazo para Gerar Referências:</strong> {{ $deadlineMessage }}
                                        </div>
                                        @if(!$canGenerate)
                                            <a href="{{ route('admin.fee.deadlines') }}" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-cog"></i> Ajustar Prazo
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            <!-- Período de Validade da Referência -->
                            <h6 class="fw-bold mb-3">Período de Validade da Referência</h6>
                            <p class="text-muted small mb-3">Defina por quanto tempo a referência ficará válida para pagamento</p>

                            <div class="row mb-3">
                                <div class="col-12">
                                    <div class="btn-group w-100" role="group">
                                        <input type="radio" class="btn-check" wire:model="validityMode" value="days" id="validity-mode-days" autocomplete="off">
                                        <label class="btn btn-outline-primary" for="validity-mode-days">
                                            <i class="fas fa-clock me-2"></i>Por Dias
                                        </label>

                                        <input type="radio" class="btn-check" wire:model="validityMode" value="dates" id="validity-mode-dates" autocomplete="off">
                                        <label class="btn btn-outline-primary" for="validity-mode-dates">
                                            <i class="fas fa-calendar-alt me-2"></i>Por Datas
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Modo 1: Por Dias -->
                            @if($validityMode === 'days')
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Data de Início *</label>
                                        <input type="date" wire:model="startDate" class="form-control @if($this->start_date_mismatch) border-warning @endif">
                                        @error('startDate') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                        @if($this->start_date_mismatch)
                                            <div class="alert alert-warning mt-2 py-2 px-3 small">
                                                <i class="fas fa-exclamation-triangle me-1"></i>
                                                <strong>Atenção:</strong> A data de início não corresponde ao mês/ano selecionado ({{ $feeMonth === 'annual' ? 'Anual' : ucfirst($feeMonth) }}/{{ $feeYear }}).
                                            </div>
                                        @endif
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Validade (dias) *</label>
                                        <select wire:model="validityDays" class="form-select">
                                            <option value="3">3 dias</option>
                                            <option value="7">7 dias (1 semana)</option>
                                            <option value="15">15 dias</option>
                                            <option value="30">30 dias (1 mês)</option>
                                            <option value="60">60 dias (2 meses)</option>
                                            <option value="90">90 dias (3 meses)</option>
                                            <option value="180">180 dias (6 meses)</option>
                                            <option value="365">365 dias (1 ano)</option>
                                        </select>
                                        @error('validityDays') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <div class="alert alert-secondary">
                                            <i class="fas fa-calendar-plus me-2"></i>
                                            <strong>Data de Fim:</strong> {{ $endDate ? \Carbon\Carbon::parse($endDate)->format('d/m/Y') : 'N/A' }}
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- Modo 2: Por Datas -->
                            @if($validityMode === 'dates')
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Data de Início *</label>
                                        <input type="date" wire:model="startDate" class="form-control @if($this->start_date_mismatch) border-warning @endif">
                                        @error('startDate') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                        @if($this->start_date_mismatch)
                                            <div class="alert alert-warning mt-2 py-2 px-3 small">
                                                <i class="fas fa-exclamation-triangle me-1"></i>
                                                <strong>Atenção:</strong> A data de início não corresponde ao mês/ano selecionado ({{ $feeMonth === 'annual' ? 'Anual' : ucfirst($feeMonth) }}/{{ $feeYear }}).
                                            </div>
                                        @endif
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Data de Fim *</label>
                                        <input type="date" wire:model="endDate" class="form-control">
                                        @error('endDate') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <div class="alert alert-secondary">
                                            <i class="fas fa-calculator me-2"></i>
                                            <strong>Dias calculados:</strong> {{ $calculatedDays ?? 'N/A' }} dias
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- Resumo Final do Período -->
                            @if($startDate && $endDate && $calculatedDays)
                                <div class="alert alert-info">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-calendar-check me-2 fs-5"></i>
                                        <div>
                                            <strong>✓ Período de Validade</strong><br>
                                            <small>
                                                De <strong>{{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }}</strong> até
                                                <strong>{{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</strong>
                                                ({{ $calculatedDays }} dias)
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="row">
                                <div class="col-12 mb-3">
                                    <label class="form-label">Descrição do Pagamento *</label>
                                    <textarea wire:model="paymentDescription" class="form-control" rows="3"
                                              placeholder="Ex: Pagamento de propina referente ao mês de Janeiro 2025"></textarea>
                                    @error('paymentDescription') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            @endif

                            <!-- Action Buttons -->
                            <div class="d-grid gap-2 mt-4">
                                @if($generationMode === 'individual')
                                    <button wire:click="generateIndividualReference"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled">
                                        <i class="fas fa-paper-plane" wire:loading.remove></i>
                                        <i class="fas fa-spinner fa-spin" wire:loading></i>
                                        <span wire:loading.remove>Gerar Referência Individual</span>
                                        <span wire:loading>Gerando...</span>
                                    </button>
                                @elseif($generationMode === 'class')
                                    <button wire:click="generateClassReferences"
                                            class="btn btn-success btn-lg"
                                            wire:loading.attr="disabled">
                                        <i class="fas fa-paper-plane" wire:loading.remove></i>
                                        <i class="fas fa-spinner fa-spin" wire:loading></i>
                                        <span wire:loading.remove>Gerar Referências para Turma</span>
                                        <span wire:loading>Gerando...</span>
                                    </button>
                                @elseif($generationMode === 'import')
                                    <button wire:click="importFromExcel"
                                            class="btn btn-warning btn-lg"
                                            wire:loading.attr="disabled">
                                        <i class="fas fa-file-import" wire:loading.remove></i>
                                        <i class="fas fa-spinner fa-spin" wire:loading></i>
                                        <span wire:loading.remove>Importar e Gerar Referências</span>
                                        <span wire:loading>Processando...</span>
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Recent References -->
                <div class="col-lg-4 mb-4">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom">
                            <h5 class="mb-0">Referências Recentes</h5>
                        </div>
                        <div class="card-body p-0">
                            @if($recentReferences && $recentReferences->count() > 0)
                                <div class="list-group list-group-flush">
                                    @foreach($recentReferences as $ref)
                                        <div class="list-group-item">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h6 class="mb-1">{{ $ref->student->name ?? 'N/A' }}</h6>
                                                    <small class="text-muted">{{ $ref->student->student_id ?? 'N/A' }}</small>
                                                </div>
                                                <span class="badge
                                                    @if($ref->status === 'paid') bg-success
                                                    @elseif($ref->status === 'pending') bg-warning text-dark
                                                    @else bg-secondary
                                                    @endif">
                                                    @if($ref->status === 'paid') Paga
                                                    @elseif($ref->status === 'pending') Pendente
                                                    @elseif($ref->status === 'cancelled') Cancelada
                                                    @else {{ ucfirst($ref->status) }}
                                                    @endif
                                                </span>
                                            </div>
                                            <div class="small">
                                                <div><strong>Entidade:</strong> {{ $ref->entity_code }}</div>
                                                <div><strong>Referência:</strong> <code>{{ $ref->reference_number }}</code></div>
                                                <div><strong>Valor:</strong> MT {{ number_format($ref->amount, 2) }} — <em>{{ $ref->metadata['description'] ?? ($ref->fee_month !== 'annual' ? 'Mensalidade' : 'Pagamento Anual') }}</em></div>
                                                <div class="text-muted">
                                                    <i class="fas fa-clock me-1"></i>
                                                    {{ $ref->created_at->diffForHumans() }}
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-5">
                                    <i class="fas fa-inbox text-muted" style="font-size: 3rem; opacity: 0.3;"></i>
                                    <p class="text-muted mt-3">Nenhuma referência gerada ainda</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabela de Todas as Referências -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">Todas as Referências Geradas</h5>
                                <button wire:click="exportToExcel" class="btn btn-success btn-sm">
                                    <i class="fas fa-file-excel me-1"></i> Exportar Excel
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Filtros -->
                            <div class="row mb-3 g-2">
                                <div class="col-md-3">
                                    <input type="text"
                                           wire:model.debounce.300ms="filterSearch"
                                           class="form-control"
                                           placeholder="Buscar...">
                                </div>
                                <div class="col-md-2">
                                    <select wire:model="filterStatus" class="form-select">
                                        <option value="">Todos os Status</option>
                                        <option value="pending">Pendentes</option>
                                        <option value="paid">Pagas</option>
                                        <option value="expired">Expiradas</option>
                                        <option value="cancelled">Canceladas</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select wire:model="filterAcademicYear" class="form-select">
                                        <option value="">Todos os Anos</option>
                                        @foreach($academicYears as $year)
                                            <option value="{{ $year }}">{{ $year }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select wire:model="filterClasse" class="form-select">
                                        <option value="">Todas as Classes</option>
                                        @foreach($classes as $classe)
                                            <option value="{{ $classe }}">{{ $classe }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select wire:model="filterTurma" class="form-select">
                                        <option value="">Todas as Turmas</option>
                                        @foreach($turmas as $turma)
                                            <option value="{{ $turma }}">{{ $turma }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 text-end">
                                    <button wire:click="clearFilters" class="btn btn-outline-secondary btn-sm w-100" title="Limpar Filtros">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>

                            <!-- Tabela -->
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Estudante</th>
                                            <th>Classe/Turma</th>
                                            <th>Ano Acadêmico</th>
                                            <th>Entidade</th>
                                            <th>Referência</th>
                                            <th>Valor</th>
                                            <th>Mês/Ano</th>
                                            <th>Validade</th>
                                            <th>Status</th>
                                            <th>Gerada em</th>
                                            <th>Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($allReferences as $ref)
                                            <tr>
                                                <td>
                                                    <div class="fw-semibold">{{ $ref->student->name ?? 'N/A' }}</div>
                                                    <small class="text-muted">{{ $ref->student->student_id ?? 'N/A' }}</small>
                                                </td>
                                                <td>
                                                    <div>
                                                        @if($ref->classe || $ref->turma)
                                                            <span class="badge bg-light text-dark">
                                                                {{ $ref->classe ?? '-' }} / {{ $ref->turma ?? '-' }}
                                                            </span>
                                                        @else
                                                            <small class="text-muted">N/A</small>
                                                        @endif
                                                    </div>
                                                </td>
                                                <td>
                                                    <small class="text-muted">{{ $ref->academic_year ?? 'N/A' }}</small>
                                                </td>
                                                <td><code>{{ $ref->entity_code }}</code></td>
                                                <td><code class="text-primary">{{ $ref->reference_number }}</code></td>
                                                <td class="fw-semibold">MT {{ number_format($ref->amount, 2) }}</td>
                                                <td>
                                                    @php
                                                        $mesesPt = ['january'=>'Janeiro','february'=>'Fevereiro','march'=>'Março','april'=>'Abril','may'=>'Maio','june'=>'Junho','july'=>'Julho','august'=>'Agosto','september'=>'Setembro','october'=>'Outubro','november'=>'Novembro','december'=>'Dezembro','annual'=>'Anual'];
                                                    @endphp
                                                    {{ $mesesPt[strtolower($ref->fee_month)] ?? ucfirst($ref->fee_month) }}/{{ $ref->fee_year }}
                                                </td>
                                                <td>
                                                    <small>
                                                        @if($ref->valid_from)
                                                            {{ \Carbon\Carbon::parse($ref->valid_from)->format('d/m/Y') }}
                                                        @else
                                                            -
                                                        @endif
                                                        até
                                                        {{ \Carbon\Carbon::parse($ref->expires_at)->format('d/m/Y') }}
                                                    </small>
                                                </td>
                                                <td>
                                                    @php
                                                        $isExpired = $ref->status === 'pending' && now()->isAfter($ref->expires_at);
                                                    @endphp
                                                    @if($ref->status === 'paid')
                                                        <span class="badge bg-success">Paga</span>
                                                    @elseif($ref->status === 'cancelled')
                                                        <span class="badge bg-secondary">Cancelada</span>
                                                    @elseif($isExpired)
                                                        <span class="badge bg-danger">Expirada</span>
                                                    @elseif($ref->status === 'pending')
                                                        <span class="badge bg-warning text-dark">Pendente</span>
                                                    @else
                                                        <span class="badge bg-secondary">{{ ucfirst($ref->status) }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <small class="text-muted">
                                                        {{ $ref->created_at->format('d/m/Y H:i') }}
                                                    </small>
                                                </td>
                                                <td>
                                                    @if($ref->status !== 'paid')
                                                        <div class="btn-group btn-group-sm">
                                                            @if($ref->status !== 'cancelled')
                                                                <button wire:click="cancelReference('{{ $ref->id }}')"
                                                                        wire:confirm="Tem certeza que deseja cancelar esta referência?"
                                                                        class="btn btn-outline-warning btn-sm"
                                                                        title="Cancelar">
                                                                    <i class="fas fa-ban"></i>
                                                                </button>
                                                            @endif
                                                            <button wire:click="deleteReference('{{ $ref->id }}')"
                                                                    wire:confirm="Tem certeza que deseja ELIMINAR permanentemente esta referência? Esta ação não pode ser desfeita."
                                                                    class="btn btn-outline-danger btn-sm"
                                                                    title="Eliminar">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    @else
                                                        <span class="text-muted small">-</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="11" class="text-center py-4 text-muted">
                                                    <i class="fas fa-inbox fa-2x mb-2 d-block"></i>
                                                    Nenhuma referência encontrada
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <!-- Paginação -->
                            <div class="mt-3">
                                {{ $allReferences->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications -->
    @if (session()->has('success'))
        <div class="position-fixed top-0 end-0 p-3" style="z-index: 11000;">
            <div class="toast show" role="alert">
                <div class="toast-header bg-success text-white">
                    <i class="fas fa-check-circle me-2"></i>
                    <strong class="me-auto">Sucesso</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                </div>
                <div class="toast-body">
                    {{ session('success') }}
                </div>
            </div>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="position-fixed top-0 end-0 p-3" style="z-index: 11000;">
            <div class="toast show" role="alert">
                <div class="toast-header bg-danger text-white">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <strong class="me-auto">Erro</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                </div>
                <div class="toast-body">
                    {{ session('error') }}
                </div>
            </div>
        </div>
    @endif
</div>

<style>
.avatar-sm {
    width: 36px;
    height: 36px;
    font-size: 14px;
}

.toast {
    min-width: 300px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar toasts
    const toastElements = document.querySelectorAll('.toast');
    toastElements.forEach(function(toastEl) {
        const toast = new bootstrap.Toast(toastEl, {
            autohide: true,
            delay: 5000
        });

        // Adicionar evento de clique no botão de fechar
        const closeBtn = toastEl.querySelector('.btn-close');
        if (closeBtn) {
            closeBtn.addEventListener('click', function() {
                toast.hide();
            });
        }

        // Mostrar o toast
        toast.show();
    });
});
</script>
