<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-chart-bar text-primary me-2"></i>Relatório de Referências de Pagamento</h4>
                        <p class="text-muted mb-0">Visualize e filtre todas as referências geradas</p>
                    </div>
                    <div>
                        <a href="{{ route('admin.fee.generate-references') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Gerar Novas Referências
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Total Referências</p>
                                <h4 class="mb-0">{{ number_format($stats['total_references'] ?? 0) }}</h4>
                            </div>
                            <div>
                                <i class="fas fa-receipt fa-2x text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Valor Total</p>
                                <h4 class="mb-0 text-success">{{ number_format($stats['total_amount'] ?? 0, 2) }} MT</h4>
                            </div>
                            <div>
                                <i class="fas fa-dollar-sign fa-2x text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Pendentes</p>
                                <h4 class="mb-0 text-warning">{{ number_format($stats['pending'] ?? 0) }}</h4>
                                <small class="text-muted">{{ number_format($stats['pending_amount'] ?? 0, 2) }} MT</small>
                            </div>
                            <div>
                                <i class="fas fa-clock fa-2x text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Pagos</p>
                                <h4 class="mb-0 text-success">{{ number_format($stats['paid'] ?? 0) }}</h4>
                                <small class="text-muted">{{ number_format($stats['paid_amount'] ?? 0, 2) }} MT</small>
                            </div>
                            <div>
                                <i class="fas fa-check-circle fa-2x text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-light">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-filter text-primary me-2"></i>Filtros Avançados
                    </h5>
                    <button wire:click="resetFilters" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-undo me-1"></i> Limpar Filtros
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <!-- Classe -->
                    <div class="col-md-3">
                        <label class="form-label">Classe</label>
                        <select wire:model="filterClass" class="form-select">
                            <option value="">Todas as Classes</option>
                            @foreach($availableClasses as $class)
                                <option value="{{ $class }}">{{ $class }}ª Classe</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Turma -->
                    <div class="col-md-3">
                        <label class="form-label">Turma</label>
                        <select wire:model="filterTurma" class="form-select" {{ !$filterClass ? 'disabled' : '' }}>
                            <option value="">Todas as Turmas</option>
                            @if($availableTurmas)
                                @foreach($availableTurmas as $turma)
                                    <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>

                    <!-- Status -->
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select wire:model="filterStatus" class="form-select">
                            <option value="">Todos</option>
                            <option value="pending">Pendente</option>
                            <option value="paid">Pago</option>
                            <option value="expired">Expirado</option>
                            <option value="cancelled">Cancelado</option>
                        </select>
                    </div>

                    <!-- Mês de Pagamento -->
                    <div class="col-md-3">
                        <label class="form-label">Mês de Pagamento</label>
                        <select wire:model="filterMonth" class="form-select">
                            <option value="">Todos</option>
                            <option value="Janeiro">Janeiro</option>
                            <option value="Fevereiro">Fevereiro</option>
                            <option value="Março">Março</option>
                            <option value="Abril">Abril</option>
                            <option value="Maio">Maio</option>
                            <option value="Junho">Junho</option>
                            <option value="Julho">Julho</option>
                            <option value="Agosto">Agosto</option>
                            <option value="Setembro">Setembro</option>
                            <option value="Outubro">Outubro</option>
                            <option value="Novembro">Novembro</option>
                            <option value="Dezembro">Dezembro</option>
                        </select>
                    </div>

                    <!-- Data Inicial -->
                    <div class="col-md-3">
                        <label class="form-label">Data Criação (De)</label>
                        <input type="date" wire:model="filterDateFrom" class="form-control">
                    </div>

                    <!-- Data Final -->
                    <div class="col-md-3">
                        <label class="form-label">Data Criação (Até)</label>
                        <input type="date" wire:model="filterDateTo" class="form-control">
                    </div>

                    <!-- Ano -->
                    <div class="col-md-3">
                        <label class="form-label">Ano de Pagamento</label>
                        <select wire:model="filterYear" class="form-select">
                            <option value="">Todos</option>
                            @foreach($availableYears as $year)
                                <option value="{{ $year }}">{{ $year }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Buscar Estudante -->
                    <div class="col-md-3">
                        <label class="form-label">Buscar Estudante</label>
                        <input type="text"
                               wire:model.debounce.500ms="searchStudent"
                               class="form-control"
                               placeholder="Nome ou código...">
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <button wire:click="applyFilters" class="btn btn-primary">
                            <i class="fas fa-search me-1"></i> Aplicar Filtros
                        </button>
                        <button wire:click="exportExcel" class="btn btn-success">
                            <i class="fas fa-file-excel me-1"></i> Exportar Excel
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- References Table -->
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>Lista de Referências
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th>Estudante</th>
                                <th>Classe/Turma</th>
                                <th>Entidade</th>
                                <th>Referência</th>
                                <th>Valor</th>
                                <th>Mês/Ano</th>
                                <th>Validade</th>
                                <th>Status</th>
                                <th>Criado em</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($references as $ref)
                                <tr>
                                    <td>
                                        <strong>{{ $ref->student->name ?? 'N/A' }}</strong><br>
                                        <small class="text-muted">{{ $ref->student->student_id ?? 'N/A' }}</small>
                                    </td>
                                    <td>
                                        {{ $ref->classe }}ª / {{ $ref->turma }}
                                    </td>
                                    <td>
                                        <code>{{ $ref->entity_code }}</code>
                                    </td>
                                    <td>
                                        <strong class="text-primary">{{ $ref->reference_number }}</strong>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($ref->amount, 2) }} MT</strong>
                                    </td>
                                    <td>
                                        {{ ucfirst($ref->fee_month) }} / {{ $ref->fee_year }}
                                    </td>
                                    <td>
                                        <small>
                                            {{ $ref->valid_from->format('d/m/Y') }}<br>
                                            até {{ $ref->expires_at->format('d/m/Y') }}
                                        </small>
                                    </td>
                                    <td>
                                        @if($ref->status == 'pending')
                                            <span class="badge bg-warning">Pendente</span>
                                        @elseif($ref->status == 'paid')
                                            <span class="badge bg-success">Pago</span>
                                        @elseif($ref->status == 'expired')
                                            <span class="badge bg-danger">Expirado</span>
                                        @else
                                            <span class="badge bg-secondary">{{ ucfirst($ref->status) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small>{{ $ref->created_at->format('d/m/Y H:i') }}</small>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3 d-block"></i>
                                        <p class="text-muted">Nenhuma referência encontrada com os filtros aplicados</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            @if($references->hasPages())
                <div class="card-footer">
                    {{ $references->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
