<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card border-0 shadow">
                        <div class="card-header bg-primary text-white py-3">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-bell me-2"></i>Enviar Notificação (Android/iOS)
                            </h2>
                        </div>
                        <div class="card-body p-4">
                            <div class="row justify-content-center">
                                <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                                    <form wire:submit.prevent="submit">
                                        <div class="mb-3">
                                            <label for="type" class="form-label fw-semibold">Enviar Para <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                                <select class="form-select" wire:model="type" id="type">
                                                    <optgroup label="Geral">
                                                        <option value="all">Todos (Estudantes + Encarregados)</option>
                                                        <option value="all_students">Todos os Estudantes</option>
                                                        <option value="all_guardians">Todos os Encarregados</option>
                                                    </optgroup>
                                                    <optgroup label="Por Turma">
                                                        <option value="class">Estudantes de Turma(s)</option>
                                                        <option value="class_guardians">Encarregados de Turma(s)</option>
                                                    </optgroup>
                                                    <optgroup label="Individual">
                                                        <option value="student">Estudante Específico</option>
                                                        <option value="guardian">Encarregado Específico</option>
                                                    </optgroup>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Selecção de turmas (para class e class_guardians) --}}
                                        @if($type == "class" || $type == "class_guardians")
                                            <div class="mb-3">
                                                <label for="class_ids" class="form-label fw-semibold">
                                                    Turmas <span class="text-danger">*</span>
                                                    <small class="text-muted">(Segure Ctrl/Cmd para selecionar múltiplas)</small>
                                                </label>
                                                <select class="form-select turma-multiselect @error('class_ids') is-invalid @enderror"
                                                        wire:model="class_ids"
                                                        id="class_ids"
                                                        multiple
                                                        size="8">
                                                    @foreach($classrooms as $class)
                                                        <option value="{{ $class->id }}">{{ $class->class }}ª Classe - {{ $class->name }}</option>
                                                    @endforeach
                                                </select>
                                                @error('class_ids')
                                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                                @enderror
                                                @if(!empty($class_ids))
                                                    <div class="mt-2">
                                                        <small class="text-success">
                                                            <i class="fas fa-check-circle me-1"></i>
                                                            {{ count($class_ids) }} turma(s) selecionada(s)
                                                        </small>
                                                    </div>
                                                @endif
                                            </div>
                                        @endif

                                        {{-- Selecção de turma + estudante (para student) --}}
                                        @if($type == "student")
                                            <div class="mb-3">
                                                <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-light"><i class="fas fa-school"></i></span>
                                                    <select class="form-select @error('class_id') is-invalid @enderror" wire:model="class_id" id="class_id">
                                                        <option value="">Selecione a Turma</option>
                                                        @foreach($classrooms as $class)
                                                            <option value="{{ $class->id }}">{{ $class->class }}ª - {{ $class->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('class_id')
                                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                                    <select class="form-select @error('student_id') is-invalid @enderror" wire:model="student_id" id="student_id">
                                                        <option value="">Selecione o Estudante</option>
                                                        @foreach($students as $student)
                                                            <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('student_id')
                                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif

                                        {{-- Selecção de encarregado (para guardian) --}}
                                        @if($type == "guardian")
                                            <div class="mb-3">
                                                <label for="guardian_id" class="form-label fw-semibold">Encarregado <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-light"><i class="fas fa-user-shield"></i></span>
                                                    <select class="form-select @error('guardian_id') is-invalid @enderror" wire:model="guardian_id" id="guardian_id">
                                                        <option value="">Selecione o Encarregado</option>
                                                        @foreach($guardians as $g)
                                                            <option value="{{ $g->id }}">{{ $g->name }} ({{ $g->phone }})</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('guardian_id')
                                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif

                                        <div class="mb-3">
                                            <label for="title" class="form-label fw-semibold">Título <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                                <input type="text"
                                                       class="form-control @error('title') is-invalid @enderror"
                                                       id="title"
                                                       wire:model="title"
                                                       placeholder="Escreva o título da notificação..."
                                                       required>
                                            </div>
                                            @error('title')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="message" class="form-label fw-semibold">Mensagem <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-comment-dots"></i></span>
                                                <textarea class="form-control @error('message') is-invalid @enderror"
                                                          id="message"
                                                          wire:model="message"
                                                          rows="4"
                                                          placeholder="Escreva a mensagem da notificação..."
                                                          required></textarea>
                                            </div>
                                            @error('message')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="d-flex justify-content-end border-top pt-4 mt-4">
                                            <button type="submit"
                                                    class="btn btn-primary px-5"
                                                    wire:loading.attr="disabled"
                                                    wire:target="submit">
                                                <span wire:loading wire:target="submit" class="spinner-border spinner-border-sm me-2"></span>
                                                <i wire:loading.remove wire:target="submit" class="fas fa-paper-plane me-2"></i>
                                                Enviar Notificação
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .turma-multiselect {
            min-height: 200px !important;
            border: 2px solid #e3e6f0;
            border-radius: 0.35rem;
            padding: 0.5rem;
            background-color: #fff;
        }

        .turma-multiselect:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .turma-multiselect option {
            padding: 0.75rem;
            margin-bottom: 0.25rem;
            border-radius: 0.25rem;
            cursor: pointer;
            transition: all 0.2s;
        }

        .turma-multiselect option:hover {
            background-color: #e7f3ff;
            color: #0066cc;
        }

        .turma-multiselect option:checked {
            background: linear-gradient(135deg, #0066cc 0%, #004c99 100%);
            color: white;
            font-weight: 600;
        }

        .turma-multiselect option:checked:hover {
            background: linear-gradient(135deg, #004c99 0%, #003366 100%);
        }
    </style>
</div>