<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-boxes text-primary me-2"></i>Gestão de Produtos</h4>
                        <p class="text-muted mb-0">Gerencie o catálogo de produtos da loja</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.pos.interface') }}" class="btn btn-outline-primary">
                            <i class="fas fa-cash-register me-1"></i> Ir para POS
                        </a>
                        <button wire:click="openModal" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Novo Produto
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="row mb-3">
            <div class="col-md-4">
                <input
                    type="text"
                    wire:model.debounce.300ms="search"
                    class="form-control"
                    placeholder="Pesquisar por nome ou SKU..."
                />
            </div>
            <div class="col-md-3">
                <select wire:model="categoryFilter" class="form-select">
                    <option value="">Todas as Categorias</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <select wire:model="stockFilter" class="form-select">
                    <option value="">Todos os Produtos</option>
                    <option value="low">Stock Baixo</option>
                    <option value="out">Sem Stock</option>
                </select>
            </div>
            <div class="col-md-2">
                <a href="{{ route('admin.pos.categories') }}" class="btn btn-outline-info w-100">
                    <i class="fas fa-tags me-1"></i> Categorias
                </a>
            </div>
        </div>

        <!-- Products Table -->
        <div class="card shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th width="80">Imagem</th>
                                <th>Nome</th>
                                <th>SKU</th>
                                <th>Categoria</th>
                                <th>Preço Custo</th>
                                <th>Preço Venda</th>
                                <th>Stock</th>
                                <th>Status</th>
                                <th width="150">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($products as $product)
                                <tr>
                                    <td>
                                        @if($product->image)
                                            <img src="{{ asset('storage/' . $product->image) }}"
                                                 class="img-thumbnail"
                                                 style="width: 50px; height: 50px; object-fit: cover;"
                                                 alt="{{ $product->name }}">
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center"
                                                 style="width: 50px; height: 50px;">
                                                <i class="fas fa-box text-muted"></i>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <strong>{{ $product->name }}</strong>
                                        @if($product->description)
                                            <br><small class="text-muted">{{ Str::limit($product->description, 50) }}</small>
                                        @endif
                                    </td>
                                    <td><code>{{ $product->sku }}</code></td>
                                    <td>
                                        <span class="badge" style="background-color: {{ $product->category->color }}">
                                            {{ $product->category->name }}
                                        </span>
                                    </td>
                                    <td>{{ number_format($product->cost_price, 2) }} MT</td>
                                    <td>
                                        @if($product->discount_price)
                                            <s class="text-muted">{{ number_format($product->selling_price, 2) }}</s>
                                            <br>
                                            <strong class="text-success">{{ number_format($product->discount_price, 2) }} MT</strong>
                                        @else
                                            <strong>{{ number_format($product->selling_price, 2) }} MT</strong>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $product->stock_status == 'in_stock' ? 'success' : ($product->stock_status == 'low_stock' ? 'warning' : 'danger') }}">
                                            {{ $product->quantity }} {{ $product->unit }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($product->is_active)
                                            <span class="badge bg-success">Ativo</span>
                                        @else
                                            <span class="badge bg-secondary">Inativo</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button wire:click="edit('{{ $product->id }}')" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button wire:click="confirmDelete('{{ $product->id }}')" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4 text-muted">
                                        <i class="fas fa-box-open fa-3x mb-3"></i>
                                        <p>Nenhum produto encontrado</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-3">
                    {{ $products->links() }}
                </div>
            </div>
        </div>

        <!-- Modal -->
        @if($showModal)
            <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-lg modal-dialog-scrollable">
                    <div class="modal-content">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title">
                                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-2"></i>
                                {{ $editMode ? 'Editar Produto' : 'Novo Produto' }}
                            </h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeModal"></button>
                        </div>
                        <div class="modal-body">
                            <form wire:submit.prevent="save">
                                <div class="row">
                                    <!-- Basic Info -->
                                    <div class="col-md-8 mb-3">
                                        <label class="form-label">Nome do Produto <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="name" class="form-control @error('name') is-invalid @enderror" />
                                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">SKU <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="sku" class="form-control @error('sku') is-invalid @enderror" />
                                        @error('sku') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Descrição</label>
                                        <textarea wire:model="description" class="form-control" rows="2"></textarea>
                                    </div>

                                    <!-- Category & Pricing -->
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Categoria <span class="text-danger">*</span></label>
                                        <select wire:model="category_id" class="form-select @error('category_id') is-invalid @enderror">
                                            <option value="">Selecione...</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Unidade <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="unit" class="form-control @error('unit') is-invalid @enderror" placeholder="Ex: Unidade, Kg, Litro" />
                                        @error('unit') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Preço de Custo <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" wire:model="cost_price" step="0.01" class="form-control @error('cost_price') is-invalid @enderror" />
                                            <span class="input-group-text">MT</span>
                                        </div>
                                        @error('cost_price') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Preço de Venda <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" wire:model="selling_price" step="0.01" class="form-control @error('selling_price') is-invalid @enderror" />
                                            <span class="input-group-text">MT</span>
                                        </div>
                                        @error('selling_price') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Preço com Desconto</label>
                                        <div class="input-group">
                                            <input type="number" wire:model="discount_price" step="0.01" class="form-control" />
                                            <span class="input-group-text">MT</span>
                                        </div>
                                    </div>

                                    <!-- Stock -->
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Quantidade em Stock <span class="text-danger">*</span></label>
                                        <input type="number" wire:model="quantity" class="form-control @error('quantity') is-invalid @enderror" />
                                        @error('quantity') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Stock Mínimo <span class="text-danger">*</span></label>
                                        <input type="number" wire:model="min_stock" class="form-control @error('min_stock') is-invalid @enderror" />
                                        @error('min_stock') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    </div>

                                    <!-- Image -->
                                    <div class="col-12 mb-3">
                                        <label class="form-label">Imagem do Produto</label>
                                        <input type="file" wire:model="image" class="form-control" accept="image/*" />
                                        @if($existingImage && !$image)
                                            <img src="{{ asset('storage/' . $existingImage) }}" class="mt-2" style="height: 100px;" />
                                        @endif
                                        @error('image') <div class="text-danger small">{{ $message }}</div> @enderror
                                    </div>

                                    <!-- Status -->
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" wire:model="is_active" id="isActive">
                                            <label class="form-check-label" for="isActive">Produto Ativo</label>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" wire:model="track_stock" id="trackStock">
                                            <label class="form-check-label" for="trackStock">Controlar Stock</label>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancelar</button>
                            <button type="button" wire:click="save" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Salvar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
