<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-chart-line text-primary me-2"></i>Relatório de Vendas</h4>
                        <p class="text-muted mb-0">Visualize e analise todas as vendas realizadas</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.pos.interface') }}" class="btn btn-primary">
                            <i class="fas fa-cash-register me-1"></i> Nova Venda
                        </a>
                        <a href="{{ route('admin.pos.dashboard') }}" class="btn btn-outline-info">
                            <i class="fas fa-chart-pie me-1"></i> Dashboard
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Date Filters -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="btn-group" role="group">
                    <button wire:click="setDateRange('today')" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-calendar-day me-1"></i> Hoje
                    </button>
                    <button wire:click="setDateRange('yesterday')" class="btn btn-sm btn-outline-primary">
                        Ontem
                    </button>
                    <button wire:click="setDateRange('week')" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-calendar-week me-1"></i> Esta Semana
                    </button>
                    <button wire:click="setDateRange('month')" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-calendar-alt me-1"></i> Este Mês
                    </button>
                    <button wire:click="setDateRange('last_month')" class="btn btn-sm btn-outline-primary">
                        Mês Passado
                    </button>
                    <button wire:click="setDateRange('year')" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-calendar me-1"></i> Este Ano
                    </button>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Total de Vendas</p>
                                <h4 class="mb-0">{{ number_format($total_sales) }}</h4>
                            </div>
                            <div>
                                <i class="fas fa-shopping-cart fa-2x text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Receita Total</p>
                                <h4 class="mb-0 text-success">{{ number_format($total_revenue, 2) }} MT</h4>
                            </div>
                            <div>
                                <i class="fas fa-dollar-sign fa-2x text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">IVA Cobrado</p>
                                <h4 class="mb-0 text-info">{{ number_format($total_tax, 2) }} MT</h4>
                            </div>
                            <div>
                                <i class="fas fa-percentage fa-2x text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Venda Média</p>
                                <h4 class="mb-0 text-warning">{{ number_format($average_sale, 2) }} MT</h4>
                            </div>
                            <div>
                                <i class="fas fa-chart-bar fa-2x text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-light">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-filter text-primary me-2"></i>Filtros Avançados
                    </h5>
                    <button wire:click="resetFilters" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-undo me-1"></i> Limpar Filtros
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Data Inicial</label>
                        <input type="date" wire:model="date_from" class="form-control">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Data Final</label>
                        <input type="date" wire:model="date_to" class="form-control">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Método de Pagamento</label>
                        <select wire:model="payment_method" class="form-select">
                            <option value="">Todos</option>
                            <option value="cash">Dinheiro</option>
                            <option value="mpesa">M-Pesa</option>
                            <option value="emola">e-Mola</option>
                            <option value="bank_transfer">Transferência Bancária</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select wire:model="status" class="form-select">
                            <option value="">Todos</option>
                            <option value="completed">Completo</option>
                            <option value="pending">Pendente</option>
                            <option value="cancelled">Cancelado</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Valor Mínimo (MT)</label>
                        <input type="number" wire:model="min_amount" class="form-control" step="0.01" placeholder="0.00">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Valor Máximo (MT)</label>
                        <input type="number" wire:model="max_amount" class="form-control" step="0.01" placeholder="0.00">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Pesquisar</label>
                        <input type="text" wire:model.debounce.500ms="search" class="form-control"
                               placeholder="Número da venda, notas...">
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <button wire:click="applyFilters" class="btn btn-primary">
                            <i class="fas fa-search me-1"></i> Aplicar Filtros
                        </button>
                        <button wire:click="exportExcel" class="btn btn-success">
                            <i class="fas fa-file-excel me-1"></i> Exportar Excel
                        </button>
                        <button wire:click="exportPDF" class="btn btn-danger">
                            <i class="fas fa-file-pdf me-1"></i> Exportar PDF
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sales Table -->
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>Lista de Vendas
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th>Nº Venda</th>
                                <th>Data/Hora</th>
                                <th>Cliente</th>
                                <th>Itens</th>
                                <th>Subtotal</th>
                                <th>Desconto</th>
                                <th>IVA</th>
                                <th>Total</th>
                                <th>Pagamento</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($sales as $sale)
                                <tr>
                                    <td>
                                        <strong class="text-primary">{{ $sale->sale_number }}</strong>
                                    </td>
                                    <td>
                                        <small>
                                            {{ $sale->sale_date->format('d/m/Y') }}<br>
                                            <span class="text-muted">{{ $sale->sale_date->format('H:i') }}</span>
                                        </small>
                                    </td>
                                    <td>
                                        @if($sale->user)
                                            <small>{{ $sale->user->name }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $sale->items->count() }} itens</span>
                                    </td>
                                    <td>{{ number_format($sale->subtotal, 2) }} MT</td>
                                    <td>
                                        @if($sale->discount > 0)
                                            <span class="text-danger">-{{ number_format($sale->discount, 2) }} MT</span>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>
                                        @if($sale->tax > 0)
                                            <span class="text-success">+{{ number_format($sale->tax, 2) }} MT</span>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($sale->total, 2) }} MT</strong>
                                    </td>
                                    <td>
                                        @if($sale->payment_method == 'cash')
                                            <span class="badge bg-success">Dinheiro</span>
                                        @elseif($sale->payment_method == 'mpesa')
                                            <span class="badge bg-primary">M-Pesa</span>
                                        @elseif($sale->payment_method == 'emola')
                                            <span class="badge bg-info">e-Mola</span>
                                        @else
                                            <span class="badge bg-secondary">{{ ucfirst($sale->payment_method) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($sale->status == 'completed')
                                            <span class="badge bg-success">Completo</span>
                                        @elseif($sale->status == 'pending')
                                            <span class="badge bg-warning">Pendente</span>
                                        @else
                                            <span class="badge bg-danger">Cancelado</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.pos.receipt', $sale->id) }}"
                                               class="btn btn-outline-primary"
                                               target="_blank"
                                               title="Ver Recibo">
                                                <i class="fas fa-receipt"></i>
                                            </a>
                                            <button type="button"
                                                    class="btn btn-outline-info"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#saleDetailsModal{{ $sale->id }}"
                                                    title="Ver Detalhes">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </div>

                                        <!-- Sale Details Modal -->
                                        <div class="modal fade" id="saleDetailsModal{{ $sale->id }}" tabindex="-1">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-primary text-white">
                                                        <h5 class="modal-title">
                                                            <i class="fas fa-info-circle me-2"></i>Detalhes da Venda - {{ $sale->sale_number }}
                                                        </h5>
                                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row mb-3">
                                                            <div class="col-md-6">
                                                                <strong>Data:</strong> {{ $sale->sale_date->format('d/m/Y H:i') }}<br>
                                                                <strong>Caixa:</strong> {{ $sale->cashier->name ?? '-' }}<br>
                                                                <strong>Cliente:</strong> {{ $sale->user->name ?? 'Cliente Geral' }}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <strong>Pagamento:</strong> {{ ucfirst($sale->payment_method) }}<br>
                                                                <strong>Status:</strong> {{ ucfirst($sale->status) }}<br>
                                                                @if($sale->notes)
                                                                    <strong>Notas:</strong> {{ $sale->notes }}
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <h6 class="border-bottom pb-2">Produtos</h6>
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Produto</th>
                                                                    <th>SKU</th>
                                                                    <th>Qtd</th>
                                                                    <th>Preço Unit.</th>
                                                                    <th>Total</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($sale->items as $item)
                                                                    <tr>
                                                                        <td>
                                                                            {{ $item->product_name }}
                                                                            @if($item->variant)
                                                                                <br><small class="text-muted">({{ $item->variant }})</small>
                                                                            @endif
                                                                        </td>
                                                                        <td><small>{{ $item->product_sku }}</small></td>
                                                                        <td>{{ $item->quantity }}</td>
                                                                        <td>{{ number_format($item->unit_price, 2) }} MT</td>
                                                                        <td>{{ number_format($item->total, 2) }} MT</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>

                                                        <div class="row mt-3">
                                                            <div class="col-md-6 offset-md-6">
                                                                <table class="table table-sm">
                                                                    <tr>
                                                                        <td>Subtotal:</td>
                                                                        <td class="text-end">{{ number_format($sale->subtotal, 2) }} MT</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Desconto:</td>
                                                                        <td class="text-end text-danger">-{{ number_format($sale->discount, 2) }} MT</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>IVA:</td>
                                                                        <td class="text-end">{{ number_format($sale->tax, 2) }} MT</td>
                                                                    </tr>
                                                                    <tr class="fw-bold">
                                                                        <td>Total:</td>
                                                                        <td class="text-end text-success">{{ number_format($sale->total, 2) }} MT</td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <a href="{{ route('admin.pos.receipt', $sale->id) }}"
                                                           class="btn btn-primary"
                                                           target="_blank">
                                                            <i class="fas fa-receipt me-1"></i> Ver Recibo
                                                        </a>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="11" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3 d-block"></i>
                                        <p class="text-muted">Nenhuma venda encontrada com os filtros aplicados</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            @if($sales->hasPages())
                <div class="card-footer">
                    {{ $sales->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
