<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Pagamentos</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 9px;
            color: #1f2937;
            line-height: 1.3;
        }

        .company-header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 3px solid #1e40af;
        }

        .company-name {
            font-size: 20px;
            font-weight: 700;
            color: #1e40af;
            margin-bottom: 5px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .company-details {
            font-size: 8px;
            color: #6b7280;
            margin-bottom: 8px;
        }

        .report-title {
            text-align: center;
            font-size: 16px;
            font-weight: 700;
            color: #000000;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .report-date {
            text-align: center;
            font-size: 8px;
            color: #6b7280;
            margin-bottom: 15px;
        }

        .filters-section {
            background: #f9fafb;
            padding: 10px;
            border: 1px solid #e5e7eb;
            border-radius: 4px;
            margin-bottom: 15px;
        }

        .section-title {
            background: #6b7280;
            color: white;
            padding: 5px 8px;
            font-size: 9px;
            font-weight: 600;
            text-transform: uppercase;
            margin-bottom: 8px;
            border-radius: 3px;
            display: inline-block;
            width: 100%;
        }

        .filters-content ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .filters-content li {
            padding: 2px 0;
            font-size: 8px;
            color: #374151;
        }

        .summary-section {
            background: #f0fdf4;
            padding: 10px;
            border: 2px solid #059669;
            border-radius: 4px;
            margin-top: 20px;
            margin-bottom: 15px;
        }

        .summary-section .section-title {
            background: #059669;
        }

        .summary-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }

        .summary-table td {
            padding: 6px 10px;
            font-size: 9px;
            border-bottom: 1px solid #d1fae5;
        }

        .summary-table td:first-child {
            font-weight: 600;
            color: #374151;
            width: 70%;
        }

        .summary-table td:last-child {
            text-align: right;
            font-weight: 700;
            color: #059669;
            font-size: 10px;
        }

        .summary-table tr:last-child td {
            border-bottom: none;
            font-size: 11px;
            padding-top: 8px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        table thead {
            background: #3b82f6;
            color: white;
        }

        table thead th {
            padding: 8px 4px;
            text-align: center;
            font-size: 8px;
            font-weight: 600;
            border: 1px solid #2563eb;
        }

        table tbody td {
            padding: 6px 4px;
            border: 1px solid #e5e7eb;
            font-size: 8px;
            vertical-align: middle;
        }

        table tbody tr:nth-child(even) {
            background: #f9fafb;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .text-left {
            text-align: left;
        }

        .font-bold {
            font-weight: 700;
        }

        .text-danger {
            color: #dc2626;
        }

        .text-muted {
            color: #9ca3af;
        }

        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 7px;
            font-weight: 600;
            background: #6b7280;
            color: white;
        }

        .footer {
            position: fixed;
            bottom: 10px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 7px;
            color: #9ca3af;
            border-top: 1px solid #e5e7eb;
            padding-top: 5px;
        }

        .page-break {
            page-break-after: always;
        }

        @page {
            margin: 15px;
        }

        /* Watermark - Padrão repetido e discreto */
        .watermark {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            pointer-events: none;
            overflow: hidden;
        }

        .watermark-item {
            position: absolute;
            font-size: 45px;
            font-weight: 600;
            color: rgba(148, 163, 184, 0.035);
            transform: rotate(-45deg);
            white-space: nowrap;
            letter-spacing: 3px;
            font-family: 'DejaVu Sans', Arial, sans-serif;
        }
    </style>
</head>
<body>
    <!-- Watermark - Padrão grid repetido -->
    <div class="watermark">
        @php
            $appName = config('app.name');
            $rows = 5; // Linhas
            $cols = 3; // Colunas
            $verticalSpacing = 100 / ($rows + 1);
            $horizontalSpacing = 100 / ($cols + 1);
        @endphp

        @for($row = 1; $row <= $rows; $row++)
            @for($col = 1; $col <= $cols; $col++)
                @php
                    $top = $row * $verticalSpacing;
                    $left = $col * $horizontalSpacing;
                @endphp
                <div class="watermark-item" style="top: {{ $top }}%; left: {{ $left }}%;">{{ $appName }}</div>
            @endfor
        @endfor
    </div>
    <!-- Report Title -->
    <div class="report-title">
        RELATÓRIO DE PAGAMENTOS
    </div>

    <div class="report-date">
        Gerado em {{ now()->format('d/m/Y H:i') }}
    </div>

    <!-- Filters Section -->
    <div class="filters-section">
        <div class="section-title">Filtros Aplicados</div>
        <div class="filters-content">
            <ul>
                @foreach($filters as $filter)
                    <li>• {{ $filter }}</li>
                @endforeach
            </ul>
        </div>
    </div>

    <!-- Data Table -->
    <table>
        <thead>
            <tr>
                <th style="width: 3%">#</th>
                <th style="width: 18%">Estudante</th>
                <th style="width: 9%">Código</th>
                <th style="width: 12%">Turma</th>
                <th style="width: 9%">Referência</th>
                <th style="width: 9%">Nº Recibo</th>
                <th style="width: 7%">Mês/Ano</th>
                <th style="width: 10%">Valor</th>
                <th style="width: 10%">Multa</th>
                <th style="width: 10%">Total</th>
                <th style="width: 3%">Data</th>
            </tr>
        </thead>
        <tbody>
            @php
            $monthsPt = ['january'=>'Janeiro','february'=>'Fevereiro','march'=>'Março','april'=>'Abril','may'=>'Maio','june'=>'Junho','july'=>'Julho','august'=>'Agosto','september'=>'Setembro','october'=>'Outubro','november'=>'Novembro','december'=>'Dezembro','janeiro'=>'Janeiro','fevereiro'=>'Fevereiro','março'=>'Março','abril'=>'Abril','maio'=>'Maio','junho'=>'Junho','julho'=>'Julho','agosto'=>'Agosto','setembro'=>'Setembro','outubro'=>'Outubro','novembro'=>'Novembro','dezembro'=>'Dezembro'];
        @endphp
        @foreach($results as $index => $payment)
                @php
                    $baseAmount = $payment->amount ?? 0;
                    $fineAmount = $payment->fine ?? 0;
                    $discountAmount = $payment->discount ?? 0;
                    $totalRow = $baseAmount + $fineAmount - $discountAmount;
                    $monthLabel = $monthsPt[strtolower($payment->month ?? '')] ?? ucfirst($payment->month ?? 'N/A');
                @endphp
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td class="text-left font-bold">{{ $payment->student->name ?? 'N/A' }}</td>
                    <td class="text-center">{{ $payment->student->student_id ?? 'N/A' }}</td>
                    <td class="text-left">{{ $payment->student->classroom->class ?? 'N/A' }} - {{ $payment->student->classroom->name ?? '' }}</td>
                    <td class="text-center">
                        <span class="badge">{{ $payment->paymentReference->reference_number ?? ($payment->reference_number ?? 'N/A') }}</span>
                    </td>
                    <td class="text-center">
                        @if($payment->receiptNumber)
                            <span class="badge">{{ $payment->receiptNumber->receipt_number }}</span>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td class="text-center">{{ $monthLabel }}/{{ $payment->year }}</td>
                    <td class="text-right">MT {{ number_format($baseAmount, 2, ',', '.') }}</td>
                    <td class="text-right">
                        @if($fineAmount > 0)
                            <span class="text-danger">MT {{ number_format($fineAmount, 2, ',', '.') }}</span>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td class="text-right font-bold">MT {{ number_format($totalRow, 2, ',', '.') }}</td>
                    <td class="text-center text-muted">{{ \Carbon\Carbon::parse($payment->created_at)->format('d/m/Y') }}</td>
                </tr>

                @if(($index + 1) % 30 == 0 && $index + 1 < count($results))
                    </tbody>
                    </table>
                    <div class="page-break"></div>

                    <!-- Repeat header on new page -->
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 3%">#</th>
                                <th style="width: 18%">Estudante</th>
                                <th style="width: 9%">Código</th>
                                <th style="width: 12%">Turma</th>
                                <th style="width: 9%">Referência</th>
                                <th style="width: 9%">Nº Recibo</th>
                                <th style="width: 7%">Mês/Ano</th>
                                <th style="width: 10%">Valor</th>
                                <th style="width: 10%">Multa</th>
                                <th style="width: 10%">Total</th>
                                <th style="width: 3%">Data</th>
                            </tr>
                        </thead>
                        <tbody>
                @endif
            @endforeach
        </tbody>
    </table>

    <!-- Summary Section - DEPOIS DA TABELA -->
    <div class="summary-section">
        <div class="section-title">Resumo Financeiro</div>
        <table class="summary-table">
            <tr>
                <td>Total de Registros:</td>
                <td>{{ number_format($total_count, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td>Subtotal (sem multa):</td>
                <td>MT {{ number_format($subtotal, 2, ',', '.') }}</td>
            </tr>
            <tr>
                <td>Multas:</td>
                <td>MT {{ number_format($total_fine, 2, ',', '.') }}</td>
            </tr>
            <tr>
                <td><strong>TOTAL GERAL:</strong></td>
                <td><strong>MT {{ number_format($total_amount, 2, ',', '.') }}</strong></td>
            </tr>
        </table>
    </div>

    <!-- Footer -->
    <div class="footer">
        Relatório gerado automaticamente pelo Sistema de Gestão Escolar em {{ now()->format('d/m/Y H:i:s') }}
    </div>
</body>
</html>
