<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    {{-- Header --}}
                    <div class="mb-3">
                        <a href="{{ route('admin.secretary.show', $preEnrollmentId) }}" class="btn btn-sm btn-outline-secondary mb-2">
                            <i class="fas fa-arrow-left me-1"></i> Voltar
                        </a>
                        <h5 class="mb-0" style="font-weight: 600; color: #1e293b;">
                            <i class="fas fa-edit me-2" style="color: #2e86de;"></i>
                            Editar Pré-inscrição
                        </h5>
                        <small class="text-muted">Editar dados da pré-inscrição / matrícula</small>
                    </div>

                    {{-- OCR BI Upload --}}
                    <div class="card mb-3" style="border: 2px dashed #2e86de; border-radius: 10px; background: #f0f7ff;">
                        <div class="card-body">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-magic fa-2x me-3 mt-1" style="color: #2e86de;"></i>
                                <div class="flex-grow-1">
                                    <h6 style="font-weight: 700; color: #1a5276; margin-bottom: 4px;">
                                        Preenchimento Automático via BI (Opcional)
                                    </h6>
                                    <p class="mb-2" style="font-size: 0.8rem; color: #64748b;">Carregue uma foto do Bilhete de Identidade para extrair dados e foto automaticamente.</p>
                                    <div class="row g-2 align-items-end">
                                        <div class="col-md-5">
                                            <label class="form-label" style="font-size: 0.75rem; font-weight: 600;">CARREGAR BI</label>
                                            <input type="file" wire:model="bi_document" class="form-control form-control-sm" accept="image/*,.pdf" id="bi_document_edit">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label" style="font-size: 0.75rem; font-weight: 600;">FOTO DO ESTUDANTE (manual)</label>
                                            <input type="file" wire:model="avatar" class="form-control form-control-sm" accept="image/*">
                                        </div>
                                        <div class="col-md-3">
                                            @if($extracted_photo_path && !$avatar)
                                                <img src="{{ asset('storage/' . $extracted_photo_path) }}" class="img-thumbnail" style="max-height: 80px; border: 2px solid #27ae60;">
                                                <small class="d-block text-success" style="font-size: 0.7rem;"><i class="fas fa-check-circle"></i> Foto extraída do BI</small>
                                            @elseif($avatar)
                                                <img src="{{ $avatar->temporaryUrl() }}" class="img-thumbnail" style="max-height: 80px;">
                                                <small class="d-block text-primary" style="font-size: 0.7rem;"><i class="fas fa-upload"></i> Foto manual</small>
                                            @endif
                                        </div>
                                    </div>
                                    <div wire:loading wire:target="bi_document" class="mt-2">
                                        <div class="d-flex align-items-center text-primary">
                                            <div class="spinner-border spinner-border-sm me-2"></div>
                                            <small><strong>Processando BI com OCR, aguarde...</strong></small>
                                        </div>
                                    </div>
                                    @if($bi_processed)
                                        <div class="alert alert-success mt-2 py-1 px-3 mb-0" style="font-size: 0.8rem;">
                                            <i class="fas fa-check-circle me-1"></i> Dados extraídos com sucesso! Verifique os campos abaixo.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 1: Dados Pessoais --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: linear-gradient(135deg, #1a5276 0%, #2e86de 100%); color: white; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem;">
                                <i class="fas fa-user me-2"></i>1 - Dados Pessoais
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME COMPLETO <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control form-control-sm @error('candidate_name') is-invalid @enderror" wire:model.defer="candidate_name">
                                    @error('candidate_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">SEXO <span class="text-danger">*</span></label>
                                    <select class="form-select form-select-sm @error('candidate_sex') is-invalid @enderror" wire:model.defer="candidate_sex">
                                        <option value="">Selecionar</option>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Feminino">Feminino</option>
                                    </select>
                                    @error('candidate_sex') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DATA NASC. <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control form-control-sm @error('candidate_dob') is-invalid @enderror" wire:model.defer="candidate_dob">
                                    @error('candidate_dob') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">ESTADO CIVIL</label>
                                    <select class="form-select form-select-sm" wire:model.defer="marital_status">
                                        <option value="">Selecionar</option>
                                        <option value="Solteiro">Solteiro(a)</option>
                                        <option value="Casado">Casado(a)</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TELEFONE <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control form-control-sm @error('candidate_phone') is-invalid @enderror" wire:model.defer="candidate_phone">
                                    @error('candidate_phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">WHATSAPP</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="candidate_whatsapp">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">EMAIL</label>
                                    <input type="email" class="form-control form-control-sm" wire:model.defer="candidate_email">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NACIONALIDADE</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="nationality">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NUIT</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="nuit">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DOENÇA CRÓNICA</label>
                                    <select class="form-select form-select-sm" wire:model="chronic_disease">
                                        <option value="0">Não</option>
                                        <option value="1">Sim</option>
                                    </select>
                                </div>
                                @if($chronic_disease)
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">QUAL DOENÇA?</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="chronic_disease_details">
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Section 2: Documentos & Ingresso --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-file-alt me-2" style="color: #1cc88a;"></i>2 - Documentos & Ingresso
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TIPO DOCUMENTO</label>
                                    <select class="form-select form-select-sm" wire:model.defer="document_type">
                                        <option value="">Selecionar</option>
                                        <option value="BI">Bilhete de Identidade</option>
                                        <option value="Cedula">Cédula Pessoal</option>
                                        <option value="Passaporte">Passaporte</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">Nº DOCUMENTO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="document_id">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">LOCAL EMISSÃO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="document_issue_place">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">VALIDADE</label>
                                    <input type="date" class="form-control form-control-sm" wire:model.defer="document_expiry_date">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">VIA INGRESSO <span class="text-danger">*</span></label>
                                    <select class="form-select form-select-sm @error('entry_type') is-invalid @enderror" wire:model="entry_type">
                                        <option value="Normal">Normal</option>
                                        <option value="Transferencia">Transferência</option>
                                        <option value="Reingresso">Reingresso</option>
                                    </select>
                                    @error('entry_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                @if($entry_type !== 'Normal')
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">INSTITUIÇÃO ORIGEM</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="previous_institution">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">CURSO ANTERIOR</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="previous_course">
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Section 3: Naturalidade & Morada --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-map-marker-alt me-2" style="color: #fd7e14;"></i>3 - Naturalidade & Morada
                            </h6>
                        </div>
                        <div class="card-body">
                            <p class="text-muted mb-2" style="font-size: 0.75rem; text-transform: uppercase; font-weight: 600;">Naturalidade</p>
                            <div class="row g-3 mb-3">
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">LOCAL NASCIMENTO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="birth_place">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DISTRITO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="birth_district">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">PROVÍNCIA</label>
                                    <select class="form-select form-select-sm" wire:model.defer="birth_province">
                                        <option value="">Selecionar</option>
                                        @foreach(['Maputo Cidade','Maputo','Gaza','Inhambane','Sofala','Manica','Tete','Zambezia','Nampula','Cabo Delgado','Niassa'] as $prov)
                                            <option value="{{ $prov }}">{{ $prov }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <hr>
                            <p class="text-muted mb-2" style="font-size: 0.75rem; text-transform: uppercase; font-weight: 600;">Morada Actual (Residência)</p>
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">PROVÍNCIA</label>
                                    <select class="form-select form-select-sm" wire:model.defer="address_province">
                                        <option value="">Selecionar</option>
                                        @foreach(['Maputo Cidade','Maputo','Gaza','Inhambane','Sofala','Manica','Tete','Zambezia','Nampula','Cabo Delgado','Niassa'] as $prov)
                                            <option value="{{ $prov }}">{{ $prov }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DISTRITO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="address_district">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">BAIRRO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="address_bairro">
                                </div>
                                <div class="col-md-5">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">RUA / AVENIDA</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="address_street">
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">Nº CASA</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="address_house_number">
                                </div>
                                <div class="col-md-5">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">MORADA COMPLETA</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="candidate_address">
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 4: Filiação --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-users me-2" style="color: #f6c23e;"></i>4 - Filiação
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME DO PAI</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="father_name">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TELEFONE DO PAI</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="father_phone">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME DA MÃE</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="mother_name">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TELEFONE DA MÃE</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="mother_phone">
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 5: Encarregado --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-user-tie me-2" style="color: #e74a3b;"></i>5 - Encarregado de Educação
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-5">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_name">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">PARENTESCO</label>
                                    <select class="form-select form-select-sm" wire:model.defer="guardian_relationship">
                                        <option value="">Selecionar</option>
                                        <option value="Pai">Pai</option>
                                        <option value="Mae">Mãe</option>
                                        <option value="Tio/a">Tio/a</option>
                                        <option value="Avo/o">Avó/ô</option>
                                        <option value="Irmao/a">Irmão/ã</option>
                                        <option value="Outro">Outro</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TELEFONE</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_phone">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">EMAIL</label>
                                    <input type="email" class="form-control form-control-sm" wire:model.defer="guardian_email">
                                </div>
                                <div class="col-md-8">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">MORADA</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_address">
                                </div>
                            </div>
                            <hr>
                            <p class="text-muted mb-2" style="font-size: 0.75rem; text-transform: uppercase; font-weight: 600;"><i class="fas fa-file-signature me-1"></i> Dados para Termo de Compromisso</p>
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">Nº BI ENCARREGADO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_document_id">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">LOCAL EMISSÃO BI</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_document_issue_place">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DATA EMISSÃO BI</label>
                                    <input type="date" class="form-control form-control-sm" wire:model.defer="guardian_document_issue_date">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">BAIRRO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_bairro">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">QUARTEIRÃO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_quarteirao">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">LOCAL DE TRABALHO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="guardian_workplace">
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 6: Emergência --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-phone-alt me-2" style="color: #e83e8c;"></i>6 - Contacto de Emergência
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="emergency_contact_name">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TELEFONE</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="emergency_contact_phone">
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 7: Curso/Turma --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-graduation-cap me-2" style="color: #36b9cc;"></i>7 - Curso / Turma
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">CLASSE <span class="text-danger">*</span></label>
                                    <select class="form-select form-select-sm @error('desired_class') is-invalid @enderror" wire:model="desired_class">
                                        <option value="">Selecionar</option>
                                        @foreach($availableClasses as $cls)
                                            <option value="{{ $cls }}">{{ $cls }}a Classe</option>
                                        @endforeach
                                    </select>
                                    @error('desired_class') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TURMA</label>
                                    <select class="form-select form-select-sm" wire:model.defer="desired_classroom_id">
                                        <option value="">Selecionar</option>
                                        @foreach($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TURNO</label>
                                    <select class="form-select form-select-sm" wire:model.defer="desired_shift">
                                        <option value="">Selecionar</option>
                                        <option value="Diurno">Diurno</option>
                                        <option value="Tarde">Tarde</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">ANO LECTIVO <span class="text-danger">*</span></label>
                                    <select class="form-select form-select-sm @error('academic_year') is-invalid @enderror" wire:model.defer="academic_year">
                                        @for($y = date('Y'); $y <= date('Y') + 2; $y++)
                                            <option value="{{ $y }}">{{ $y }}</option>
                                        @endfor
                                    </select>
                                    @error('academic_year') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">OBSERVAÇÃO</label>
                                    <textarea class="form-control form-control-sm" wire:model.defer="observation" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Action Buttons --}}
                    <div class="d-flex justify-content-between mb-4">
                        <a href="{{ route('admin.secretary.show', $preEnrollmentId) }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-1"></i> Cancelar
                        </a>
                        <button class="btn btn-primary" wire:click="submit">
                            <i class="fas fa-save me-1"></i> Guardar Alterações
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- PDF.js for BI PDF conversion --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        if (typeof pdfjsLib !== 'undefined') {
            pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
        }
        let isConvertingPdf = false;
        document.addEventListener('livewire:load', function() {
            const biInput = document.getElementById('bi_document_edit');
            if (!biInput) return;
            biInput.addEventListener('change', async function(e) {
                const file = e.target.files[0];
                if (!file) return;
                if (file.type === 'application/pdf' && !isConvertingPdf) {
                    e.stopImmediatePropagation();
                    try {
                        isConvertingPdf = true;
                        const arrayBuffer = await file.arrayBuffer();
                        const pdf = await pdfjsLib.getDocument({ data: arrayBuffer }).promise;
                        const page = await pdf.getPage(1);
                        const viewport = page.getViewport({ scale: 3.0 });
                        const canvas = document.createElement('canvas');
                        const context = canvas.getContext('2d');
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;
                        await page.render({ canvasContext: context, viewport: viewport }).promise;
                        const blob = await new Promise(resolve => canvas.toBlob(resolve, 'image/jpeg', 0.95));
                        const imageFile = new File([blob], file.name.replace('.pdf', '.jpg'), { type: 'image/jpeg' });
                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(imageFile);
                        biInput.files = dataTransfer.files;
                        biInput.dispatchEvent(new Event('change', { bubbles: true }));
                        isConvertingPdf = false;
                    } catch (error) {
                        alert('Erro ao converter PDF. Use uma imagem (JPG/PNG).');
                        biInput.value = '';
                        isConvertingPdf = false;
                    }
                }
            }, true);
        });
    </script>
</div>
