<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    {{-- Header --}}
                    <div class="mb-3">
                        <a href="{{ route('admin.secretary.show', $preEnrollment->id) }}" class="btn btn-sm btn-outline-secondary mb-2">
                            <i class="fas fa-arrow-left me-1"></i> Voltar
                        </a>
                        <h5 class="mb-0" style="font-weight: 600; color: #1e293b;">
                            <i class="fas fa-user-check me-2" style="color: #27ae60;"></i>
                            Matrícula - {{ $preEnrollment->code }}
                        </h5>
                        <small class="text-muted">Confirmar matrícula do candidato {{ $preEnrollment->candidate_name }}</small>
                    </div>

                    {{-- Section 1: Dados Basicos da Matricula --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: linear-gradient(135deg, #1a5276 0%, #2e86de 100%); color: white; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem;">
                                <i class="fas fa-clipboard-list me-2"></i>1 - Dados Básicos da Matrícula
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TIPO</label>
                                    <input type="text" class="form-control form-control-sm" value="{{ $preEnrollment->entry_type }}" readonly style="background: #f8fafc;">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME DO ESTUDANTE</label>
                                    <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" wire:model.defer="name">
                                    @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">ID ESTUDANTE</label>
                                    <input type="text" class="form-control form-control-sm @error('student_id') is-invalid @enderror"
                                        wire:model.defer="student_id"
                                        @if($auto_generate_id) readonly style="background: #d4edda; font-weight: 600;" @endif>
                                    @error('student_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    <div class="form-check form-switch mt-1">
                                        <input class="form-check-input" type="checkbox" id="autoGenIdEnroll" wire:model="auto_generate_id">
                                        <label class="form-check-label" for="autoGenIdEnroll" style="font-size: 0.75rem; color: #64748b;">Gerar automaticamente</label>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">CLASSE</label>
                                    <select class="form-select form-select-sm @error('class') is-invalid @enderror" wire:model="class">
                                        <option value="">Selecionar</option>
                                        @foreach($availableClasses as $cls)
                                            <option value="{{ $cls }}">{{ $cls }}a Classe</option>
                                        @endforeach
                                    </select>
                                    @error('class') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TURMA</label>
                                    <select class="form-select form-select-sm @error('classroom_id') is-invalid @enderror" wire:model.defer="classroom_id">
                                        <option value="">Selecionar</option>
                                        @foreach($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('classroom_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">ANO LECTIVO</label>
                                    <select class="form-select form-select-sm @error('year_edu') is-invalid @enderror" wire:model.defer="year_edu">
                                        @for($y = date('Y'); $y <= date('Y') + 2; $y++)
                                            <option value="{{ $y }}">{{ $y }}</option>
                                        @endfor
                                    </select>
                                    @error('year_edu') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">SEXO</label>
                                    <select class="form-select form-select-sm @error('sex') is-invalid @enderror" wire:model.defer="sex">
                                        <option value="">Selecionar</option>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Feminino">Feminino</option>
                                    </select>
                                    @error('sex') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DATA NASCIMENTO</label>
                                    <input type="date" class="form-control form-control-sm @error('dob') is-invalid @enderror" wire:model.defer="dob">
                                    @error('dob') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">EMAIL</label>
                                    <input type="email" class="form-control form-control-sm @error('email') is-invalid @enderror" wire:model.defer="email">
                                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TELEFONE</label>
                                    <input type="text" class="form-control form-control-sm @error('phone_number') is-invalid @enderror" wire:model.defer="phone_number">
                                    @error('phone_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">VIA DE INGRESSO</label>
                                    <input type="text" class="form-control form-control-sm" value="{{ $preEnrollment->entry_type }}" readonly style="background: #f8fafc;">
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 2: Dados de Filiacao --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-users me-2" style="color: #4e73df;"></i>2 - Filiação e Naturalidade
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME DO PAI</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="father_name">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NOME DA MÃE</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="mother_name">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">LOCAL NASCIMENTO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="birth_place">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">DISTRITO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="birth_district">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">PROVÍNCIA</label>
                                    <select class="form-select form-select-sm" wire:model.defer="birth_province">
                                        <option value="">Selecionar</option>
                                        <option value="Maputo Cidade">Maputo Cidade</option>
                                        <option value="Maputo">Maputo</option>
                                        <option value="Gaza">Gaza</option>
                                        <option value="Inhambane">Inhambane</option>
                                        <option value="Sofala">Sofala</option>
                                        <option value="Manica">Manica</option>
                                        <option value="Tete">Tete</option>
                                        <option value="Zambezia">Zambézia</option>
                                        <option value="Nampula">Nampula</option>
                                        <option value="Cabo Delgado">Cabo Delgado</option>
                                        <option value="Niassa">Niassa</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 3: Documentacao --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-id-card me-2" style="color: #1cc88a;"></i>3 - Documentação
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">TIPO DOCUMENTO</label>
                                    <select class="form-select form-select-sm" wire:model.defer="document_type">
                                        <option value="">Selecionar</option>
                                        <option value="BI">Bilhete de Identidade</option>
                                        <option value="Cedula">Cédula Pessoal</option>
                                        <option value="Passaporte">Passaporte</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">NÚMERO DO DOCUMENTO</label>
                                    <input type="text" class="form-control form-control-sm" wire:model.defer="document_id">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">FOTO DO ESTUDANTE</label>
                                    <input type="file" class="form-control form-control-sm @error('avatar') is-invalid @enderror" wire:model="avatar" accept="image/*">
                                    @error('avatar') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    <div class="mt-2 text-center">
                                        @if($avatar)
                                            <img src="{{ $avatar->temporaryUrl() }}" alt="Preview" style="max-height: 80px; border-radius: 6px; border: 2px solid #3b82f6;">
                                            <br><small class="text-muted">Novo upload</small>
                                        @elseif($preEnrollment->candidate_photo)
                                            <img src="{{ Storage::url($preEnrollment->candidate_photo) }}" alt="Foto pré-inscrição" style="max-height: 80px; border-radius: 6px; border: 2px solid #27ae60;">
                                            <br><small class="text-success"><i class="fas fa-check-circle me-1"></i>Da pré-inscrição</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Section 4: Dados Adicionais (read-only from pre-enrollment) --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-header" style="background: #f0f7ff; padding: 0.75rem 1rem;">
                            <h6 class="mb-0" style="font-weight: 600; font-size: 0.9rem; color: #1e293b;">
                                <i class="fas fa-info-circle me-2" style="color: #6f42c1;"></i>4 - Dados Adicionais (Pré-inscrição)
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-2" style="font-size: 0.8rem;">
                                <div class="col-md-3"><span class="text-muted">Estado Civil:</span> <strong>{{ $preEnrollment->marital_status ?? '-' }}</strong></div>
                                <div class="col-md-3"><span class="text-muted">Nacionalidade:</span> <strong>{{ $preEnrollment->nationality ?? '-' }}</strong></div>
                                <div class="col-md-3"><span class="text-muted">NUIT:</span> <strong>{{ $preEnrollment->nuit ?? '-' }}</strong></div>
                                <div class="col-md-3"><span class="text-muted">Doença Crónica:</span> <strong>{{ $preEnrollment->chronic_disease ? 'Sim — ' . $preEnrollment->chronic_disease_details : 'Não' }}</strong></div>
                                <div class="col-md-4"><span class="text-muted">Morada:</span> <strong>{{ $preEnrollment->address_bairro ?? '-' }}, {{ $preEnrollment->address_district ?? '' }}</strong></div>
                                <div class="col-md-4"><span class="text-muted">Encarregado:</span> <strong>{{ $preEnrollment->guardian_name ?? '-' }} ({{ $preEnrollment->guardian_phone ?? '-' }})</strong></div>
                                <div class="col-md-4"><span class="text-muted">Turno:</span> <strong>{{ $preEnrollment->desired_shift ?? '-' }}</strong></div>
                            </div>
                        </div>
                    </div>

                    {{-- Observacao --}}
                    <div class="card mb-3" style="border: 1px solid #e2e8f0;">
                        <div class="card-body">
                            <label class="form-label" style="font-size: 0.8rem; font-weight: 600; color: #64748b;">OBSERVAÇÃO</label>
                            <textarea class="form-control form-control-sm" wire:model.defer="observation" rows="2" placeholder="Observações adicionais"></textarea>
                        </div>
                    </div>

                    {{-- Action Buttons --}}
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.secretary.show', $preEnrollment->id) }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-1"></i> Cancelar
                        </a>
                        <button class="btn btn-success" wire:click="submit">
                            <i class="fas fa-check me-1"></i> Confirmar Matrícula
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
