<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row justify-content-center">
                <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                    <!-- Header Card -->
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-primary text-white py-3">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-user-tie me-2"></i>
                                Adicionar Professor/Staff
                            </h2>
                        </div>

                        <div class="card-body p-4">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <!-- Nome Completo -->
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label fw-semibold">
                                        Nome Completo <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light">
                                            <i class="fas fa-user"></i>
                                        </span>
                                        <input
                                            type="text"
                                            id="name"
                                            wire:model="name"
                                            class="form-control @error('name') is-invalid @enderror"
                                            placeholder="Insira o nome completo..."
                                            required
                                        >
                                    </div>
                                    @error('name')
                                        <span class="text-danger small">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Email -->
                                <div class="form-group mb-3">
                                    <label for="email" class="form-label fw-semibold">
                                        Email <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                        <input
                                            type="email"
                                            id="email"
                                            wire:model="email"
                                            class="form-control @error('email') is-invalid @enderror"
                                            placeholder="exemplo@email.com"
                                            required
                                        >
                                    </div>
                                    @error('email')
                                        <span class="text-danger small">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Número Celular -->
                                <div class="form-group mb-4">
                                    <label for="phone_number" class="form-label fw-semibold">
                                        Número de Celular <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light">
                                            <i class="fas fa-phone"></i>
                                        </span>
                                        <span class="input-group-text bg-light">+258</span>
                                        <input
                                            type="text"
                                            id="phone_number"
                                            wire:model="phone_number"
                                            class="form-control @error('phone_number') is-invalid @enderror"
                                            placeholder="840000000"
                                            maxlength="9"
                                            required
                                        >
                                    </div>
                                    @error('phone_number')
                                        <span class="text-danger small">{{ $message }}</span>
                                    @enderror
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Insira apenas o número sem o código do país (+258)
                                    </small>
                                </div>

                                <!-- Alert Info -->
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Informação:</strong> Após o cadastro, será enviado um SMS com as credenciais de acesso ao sistema.
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2">
                                    <button
                                        type="submit"
                                        class="btn btn-primary btn-lg"
                                        wire:loading.attr="disabled"
                                        wire:offline.attr="disabled"
                                    >
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar Professor
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Guardando...
                                        </span>
                                    </button>

                                    <a href="{{ route('admin.list.teachers') }}" class="btn btn-outline-secondary">
                                        <i class="fas fa-arrow-left me-2"></i>Voltar à Lista
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Info Card -->
                    <div class="card border-0 shadow-sm mt-4">
                        <div class="card-body">
                            <h6 class="card-subtitle mb-3 text-muted">
                                <i class="fas fa-lightbulb me-2"></i>Dicas Importantes
                            </h6>
                            <ul class="mb-0">
                                <li class="mb-2">
                                    <i class="fas fa-check-circle text-success me-2"></i>
                                    Certifique-se de que o email é válido e ativo
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-check-circle text-success me-2"></i>
                                    O número de celular deve estar correto para receber SMS
                                </li>
                                <li class="mb-0">
                                    <i class="fas fa-check-circle text-success me-2"></i>
                                    Após o cadastro, você pode atribuir disciplinas ao professor
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
