<div>
    <div class="page-content">
        <div class="main-wrapper">

            {{-- Banner header (same style as student home notices) --}}
            <div style="background: linear-gradient(135deg, #fff5e1 0%, #ffe0b2 100%); border-radius: 16px; padding: 1.5rem; margin-bottom: 1.5rem; border-left: 4px solid #ff9800;">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 style="color: #e65100; font-weight: 700; margin: 0; font-size: 1.1rem;">
                            <i class="fas fa-bell me-2"></i>Comunicados
                        </h5>
                        @if($active_student)
                            <small style="color: #a16207; font-size: .8rem;">{{ $active_student->name }}</small>
                        @endif
                    </div>
                    @if(!$notices->isEmpty())
                        <span class="badge" style="background: #ff9800; font-size: .85rem; border-radius: 20px; padding: 4px 10px;">
                            {{ $notices->total() }}
                        </span>
                    @endif
                </div>
            </div>

            @if($notices->isEmpty())
                <div class="text-center py-5 text-muted">
                    <i class="fas fa-inbox fa-3x mb-3 d-block" style="opacity:.3;"></i>
                    <p class="mb-0">Sem comunicados activos de momento.</p>
                </div>
            @else

            {{-- Notices list --}}
            <div style="display: flex; flex-direction: column; gap: 1rem;">
                @foreach($notices as $notice)
                @php
                    $typeColors = [
                        'aviso'   => ['bg'=>'#fff7ed','color'=>'#c2410c','icon'=>'fa-exclamation-triangle'],
                        'info'    => ['bg'=>'#eff6ff','color'=>'#1d4ed8','icon'=>'fa-info-circle'],
                        'evento'  => ['bg'=>'#f0fdf4','color'=>'#15803d','icon'=>'fa-calendar-alt'],
                        'urgente' => ['bg'=>'#fef2f2','color'=>'#b91c1c','icon'=>'fa-exclamation-circle'],
                    ];
                    $tc = $typeColors[strtolower($notice->type ?? '')] ?? ['bg'=>'#eff6ff','color'=>'#1d4ed8','icon'=>'fa-info-circle'];
                @endphp
                <div style="background: white; border-radius: 12px; padding: 1rem; display: flex; gap: 12px; box-shadow: 0 2px 8px rgba(0,0,0,.05); align-items: flex-start;">
                    {{-- Icon --}}
                    <div style="width:40px;height:40px;background:{{ $tc['bg'] }};color:{{ $tc['color'] }};border-radius:10px;display:flex;align-items:center;justify-content:center;flex-shrink:0;">
                        <i class="fas {{ $tc['icon'] }}"></i>
                    </div>

                    {{-- Content --}}
                    <div class="flex-grow-1 overflow-hidden">
                        <div class="d-flex justify-content-between align-items-start flex-wrap gap-1 mb-1">
                            <h6 style="margin: 0; color: #1e293b; font-weight: 600; font-size: .95rem;">
                                {{ $notice->title }}
                            </h6>
                            <small style="color: #94a3b8; font-size: .75rem; flex-shrink: 0;">
                                <i class="fas fa-clock me-1"></i>{{ $notice->created_at->diffForHumans() }}
                            </small>
                        </div>

                        @if($notice->description)
                        <p style="margin: 0 0 .5rem; font-size: .85rem; color: #64748b; white-space: pre-line; line-height: 1.5;">
                            {{ $notice->description }}
                        </p>
                        @endif

                        @if($notice->media_url)
                        <a href="{{ $notice->media_url }}" target="_blank"
                           style="color: #ff9800; text-decoration: none; font-size: .8rem; font-weight: 500;">
                            <i class="fas fa-paperclip me-1"></i>{{ $notice->media_name ?? 'Ver anexo' }}
                        </a>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>

            <div class="mt-3">{{ $notices->links() }}</div>
            @endif

        </div>
    </div>
</div>
