<div>
    <div class="page-content">
        <div class="main-wrapper">

            <h6 class="fw-semibold text-muted mb-3"><i class="fas fa-user-graduate me-2"></i>Meus Educandos</h6>

            @if($students->count() > 0)
            <div class="row g-3">
                @foreach($students as $st)
                <div class="col-6 col-md-4 col-lg-3">
                    <a href="{{ route('guardian.estudante', $st->id) }}" class="text-decoration-none">
                        <div class="card border-0 shadow-sm h-100 text-center py-4 px-2"
                             style="cursor:pointer;transition:all .2s;"
                             onmouseover="this.style.transform='translateY(-3px)';this.style.boxShadow='0 6px 20px rgba(0,0,0,.12)'"
                             onmouseout="this.style.transform='';this.style.boxShadow=''">
                            @if($st->avatar && Str::startsWith($st->avatar, 'http'))
                                <img src="{{ $st->avatar }}" alt="{{ $st->name }}"
                                     class="rounded-circle mx-auto mb-3"
                                     style="width:56px;height:56px;object-fit:cover;">
                            @else
                                <div class="rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center"
                                     style="width:56px;height:56px;font-size:20px;font-weight:700;background:#dbeafe;color:#1e40af;">
                                    <i class="fas fa-user"></i>
                                </div>
                            @endif
                            <h6 class="fw-bold mb-1 small text-dark">{{ $st->name }}</h6>
                            <p class="mb-0 text-muted" style="font-size:12px;">
                                {{ $st->classroom?->class ?? '?' }}ª {{ $st->classroom?->name ?? '' }}
                            </p>
                        </div>
                    </a>
                </div>
                @endforeach
            </div>
            @else
                <div class="card border-0 shadow-sm text-center py-5">
                    <div class="rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center"
                         style="width:64px;height:64px;background:#f1f5f9;">
                        <i class="fas fa-user-slash fa-lg text-muted"></i>
                    </div>
                    <p class="text-muted mb-0">Nenhum estudante associado. Contacte a secretaria.</p>
                </div>
            @endif

        </div>
    </div>
</div>
