<?php
$class_id = 0;
$subjects_get = [];

if ($active_student && $models->count()) {
    $classroom = \App\Models\Classroom::query()->where("id", $active_student->classroom_id)->first();
    if ($classroom) {
        $class_id = (int) ($classroom->class ?? 0);
        $query_subjects = \App\Models\TeacherSubject::query()->where("classroom_id", $active_student->classroom_id)->get();
        foreach ($query_subjects as $sr) {
            $subject = \App\Models\Subject::query()->where("id", $sr->subject_id)->first();
            if ($subject) $subjects_get[$subject->name] = $subject->id;
        }
    }
}

$year = $search ?? date('Y');
$current_ne_subjects = $class_id ? \App\Models\ExamConfiguration::getSubjectsWithExam((int) $class_id, null, $year) : [];
$show_ne_column = count($current_ne_subjects) > 0;
?>

<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card" style="border: 1px solid #e2e8f0; border-radius: 0;">
                        <div class="card-body" style="padding: 2rem;">

                            <div class="d-flex flex-wrap justify-content-between align-items-start gap-3 mb-4">
                                <div>
                                    <h5 class="card-title mb-1" style="color: #1e293b; font-weight: 600;">Notas do estudante</h5>
                                    @if($active_student)
                                        <p class="mb-0 text-muted small">
                                            <i class="fas fa-user-graduate me-1"></i>
                                            {{ $active_student->name }}
                                            @if($active_student->classroom)
                                                &nbsp;·&nbsp; {{ $active_student->classroom->class }}ª Turma {{ $active_student->classroom->name }}
                                            @endif
                                        </p>
                                    @endif
                                </div>
                                <div>
                                    <label class="form-label" style="color:#475569;font-size:.875rem;font-weight:500;margin-bottom:.5rem;">Ano Lectivo</label>
                                    <select wire:model="search" class="form-select" style="border:1px solid #cbd5e1;border-radius:0;padding:.625rem .875rem;font-size:.9375rem;min-width:150px;">
                                        @foreach($years as $value => $label)
                                            <option value="{{ $value }}">{{ $label }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            @if(!$active_student)
                                <p class="text-center text-muted">Nenhum estudante seleccionado.</p>
                            @elseif($models->isEmpty())
                                <p class="text-center"><b>Nenhum dado foi encontrado para {{ $search }}.</b></p>
                            @else
                            <div class="table-responsive">
                                <table class="table table-sm mb-0" style="font-size:.875rem;">
                                    <thead style="background-color:#f1f5f9;">
                                        <tr>
                                            <th colspan="5" style="border-right:2px solid #e2e8f0;"><b>Primeiro Trimestre</b></th>
                                            <th colspan="4" style="border-right:2px solid #e2e8f0;"><b>Segundo Trimestre</b></th>
                                            <th colspan="{{ $show_ne_column ? 5 : 4 }}"><b>Terceiro Trimestre</b></th>
                                        </tr>
                                        <tr>
                                            <th style="color:#64748b;font-weight:600;padding:.625rem .75rem;font-size:.75rem;text-transform:uppercase;letter-spacing:.05em;border-bottom:1px solid #e2e8f0;">Disciplina</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">ACS1</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">ACS2</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">AT</th>
                                            <th class="text-center" style="color:#1e293b;font-weight:700;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;border-right:2px solid #e2e8f0;background-color:#e0e7ff;">MT</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">ACS1</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">ACS2</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">AT</th>
                                            <th class="text-center" style="color:#1e293b;font-weight:700;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;border-right:2px solid #e2e8f0;background-color:#e0e7ff;">MT</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">ACS1</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">ACS2</th>
                                            <th class="text-center" style="color:#64748b;font-weight:600;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;">AT</th>
                                            <th class="text-center" style="color:#1e293b;font-weight:700;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;background-color:#e0e7ff;">MT</th>
                                            @if($show_ne_column)
                                                <th class="text-center" style="color:#991b1b;font-weight:700;padding:.625rem .5rem;font-size:.75rem;text-transform:uppercase;border-bottom:1px solid #e2e8f0;background-color:#fee2e2;">{{ $class_id == 3 ? 'AF' : 'NE' }}</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($models as $model)
                                            @php
                                                $e2 = \App\Models\Exam::query()->where('trimester_id',2)->where('subject_id',$model->subject_id)->where('student_id',$model->student_id)->where('year',$search)->first();
                                                $e3 = \App\Models\Exam::query()->where('trimester_id',3)->where('subject_id',$model->subject_id)->where('student_id',$model->student_id)->where('year',$search)->first();
                                            @endphp
                                            <tr>
                                                <td>{{ optional($model->subject)->name ?? 'N/A' }}</td>
                                                <td class="text-center">{{ number_format($model->ACS1a ?? 0, 2) }}</td>
                                                <td class="text-center">{{ number_format($model->ACS2a ?? 0, 2) }}</td>
                                                <td class="text-center">{{ number_format($model->AT ?? 0, 2) }}</td>
                                                <td class="text-center" style="background-color:#e0e7ff;">{{ round((($model->ACS1a??0)+($model->ACS2a??0)+($model->AT??0))/3) }}</td>
                                                <td class="text-center">{{ number_format($e2->ACS1a ?? 0, 2) }}</td>
                                                <td class="text-center">{{ number_format($e2->ACS2a ?? 0, 2) }}</td>
                                                <td class="text-center">{{ number_format($e2->AT ?? 0, 2) }}</td>
                                                <td class="text-center" style="background-color:#e0e7ff;">{{ round((($e2->ACS1a??0)+($e2->ACS2a??0)+($e2->AT??0))/3) }}</td>
                                                <td class="text-center">{{ number_format($e3->ACS1a ?? 0, 2) }}</td>
                                                <td class="text-center">{{ number_format($e3->ACS2a ?? 0, 2) }}</td>
                                                <td class="text-center">{{ number_format($e3->AT ?? 0, 2) }}</td>
                                                <td class="text-center" style="background-color:#e0e7ff;">{{ round((($e3->ACS1a??0)+($e3->ACS2a??0)+($e3->AT??0))/3) }}</td>
                                                @if($show_ne_column)
                                                    @if(in_array(optional($model->subject)->name, $current_ne_subjects))
                                                        <td class="text-center">{{ number_format($e3->NE ?? 0, 2) }}</td>
                                                    @else
                                                        <td style="background-color:black;color:white;" class="text-center">N/A</td>
                                                    @endif
                                                @endif
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            {{-- RESULTADO --}}
                            <h3 style="text-align:center;margin-top:1.5rem;">RESULTADO</h3>
                            @php
                                $mfd_final_total = 0; $subject_count = 0;
                                $portugues_final = null; $matematica_final = null;
                            @endphp
                            @foreach($models as $model)
                                @php
                                    $mt1 = round((($model->ACS1a??0)+($model->ACS2a??0)+($model->AT??0))/3,2);
                                    $rs2 = \App\Models\Exam::query()->where('trimester_id',2)->where('subject_id',$model->subject_id)->where('student_id',$model->student_id)->where('year',$search)->first();
                                    $mt2 = $rs2 ? round((($rs2->ACS1a??0)+($rs2->ACS2a??0)+($rs2->AT??0))/3,2) : 0;
                                    $rs3 = \App\Models\Exam::query()->where('trimester_id',3)->where('subject_id',$model->subject_id)->where('student_id',$model->student_id)->where('year',$search)->first();
                                    $mt3 = $rs3 ? round((($rs3->ACS1a??0)+($rs3->ACS2a??0)+($rs3->AT??0))/3,2) : 0;
                                    $ne  = $rs3->NE ?? 0;
                                    $mfd = round(($mt1+$mt2+$mt3)/3,2);
                                    $sname = optional($model->subject)->name;
                                    $final = in_array($sname,$current_ne_subjects) ? round(($mfd*2+$ne)/3,2) : $mfd;
                                    $mfd_final_total += $final; $subject_count++;
                                    if ($sname==='Português')  $portugues_final  = $final;
                                    if ($sname==='Matemática') $matematica_final = $final;
                                @endphp
                            @endforeach
                            @php
                                $result = $subject_count > 0 ? round($mfd_final_total/$subject_count,2) : 0;
                                $reprovado_por_pt_mt = ($portugues_final!==null && $portugues_final>0 && $portugues_final<10)
                                                    && ($matematica_final!==null && $matematica_final>0 && $matematica_final<10);
                            @endphp
                            <h3 style="text-align:center;">
                                @if($result < 10 || $reprovado_por_pt_mt)
                                    <span style="color:red;">{{ in_array($class_id,[3,6,9,10,12]) ? 'REPROVADO' : 'NÃO TRANSITA' }}</span>
                                @else
                                    <span style="color:green;">{{ in_array($class_id,[3,6,9,10,12]) ? 'APROVADO' : 'TRANSITA' }}</span>
                                @endif
                            </h3>
                            <h3 style="text-align:center;">MF: {{ round($result) }}</h3>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
