<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Certificado - {{ $certificate->certificate_number }}</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 20mm 25mm 25mm 25mm;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Times New Roman', Times, serif;
            color: #000;
            font-size: 12pt;
            line-height: 1.5;
        }

        .container {
            width: 100%;
        }

        /* Header - Centered, 12pt, bold */
        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .header p {
            margin: 0;
            padding: 0;
            font-size: 12pt;
        }

        .header .bold {
            font-weight: bold;
        }

        .header .school-name {
            font-style: italic;
            font-weight: normal;
            margin-top: 8px;
        }

        /* Title - 16pt, bold, underlined, centered */
        .certificate-title {
            text-align: center;
            font-size: 16pt;
            font-weight: bold;
            text-decoration: underline;
            margin: 20px 0;
        }

        /* Body text - 12pt, justified */
        .body-text {
            text-align: justify;
            font-size: 12pt;
            line-height: 1.8;
            margin-bottom: 15px;
        }

        .body-text .secretary-name {
            font-size: 14pt;
        }

        .body-text .student-name {
            font-weight: bold;
        }

        /* Grades Table */
        .grades-section {
            margin: 20px 0;
        }

        .grades-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10pt;
            margin-bottom: 15px;
        }

        .grades-table th {
            background-color: #f0f0f0;
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: bold;
            font-size: 9pt;
        }

        .grades-table td {
            border: 1px solid #000;
            padding: 3px 2px;
            text-align: center;
            font-size: 10pt;
        }

        .grades-table .subject-name {
            text-align: left;
            padding-left: 5px;
        }

        .grades-table .total-row {
            font-weight: bold;
            background-color: #f9f9f9;
        }

        /* Results reference - justified, 12pt */
        .results-reference {
            text-align: justify;
            font-size: 12pt;
            line-height: 1.8;
            margin: 15px 0;
        }

        /* Date - centered, 12pt */
        .date-section {
            text-align: center;
            margin: 20px 0;
            font-size: 12pt;
        }

        /* Signatures - same as Word */
        .signatures {
            margin-top: 30px;
            font-size: 12pt;
        }

        .signature-extrai-conferi {
            text-align: justify;
            margin-bottom: 25px;
        }

        .signature-row {
            width: 100%;
            margin-top: 20px;
        }

        .signature-row::after {
            content: "";
            display: table;
            clear: both;
        }

        .signature-left {
            float: left;
            width: 45%;
            text-align: center;
        }

        .signature-right {
            float: right;
            width: 45%;
            text-align: center;
        }

        .signature-line {
            border-bottom: 1px solid #000;
            margin-bottom: 5px;
            height: 20px;
        }

        .signature-title {
            font-size: 12pt;
        }

        /* QR Code Section (small, bottom corner) */
        .qr-section {
            position: fixed;
            bottom: 20mm;
            left: 25mm;
            text-align: center;
        }

        .qr-section img {
            width: 50px;
            height: 50px;
        }

        .qr-section p {
            font-size: 6pt;
            color: #666;
            margin-top: 2px;
        }

        .verification-info {
            position: fixed;
            bottom: 20mm;
            right: 25mm;
            font-size: 7pt;
            color: #666;
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header - Exactly as Word -->
        <div class="header">
            <p class="bold">REPÚBLICA DE MOÇAMBIQUE</p>
            <p class="bold">MINISTÉRIO DA EDUCAÇÃO E DESENVOLVIMENTO HUMANO</p>
            <p class="bold">CONSELHO NACIONAL DE EXAMES, CERTIFICAÇÃO E EQUIVALÊNCIAS</p>
            <p class="school-name">Escola Secundária 12 de Outubro</p>
        </div>

        <!-- Certificate Title - Exactly as Word -->
        <h1 class="certificate-title">CERTIFICADO DE HABILITAÇÕES</h1>

        <!-- Body Text - Exactly as Word -->
        @php
            $secretaryName = 'Alves Rocha Miguel';
            $secretaryTitle = 'Técnico Superior de N1';
            $secretaryRole = 'Chefe da Secretaria da Escola Secundária 12 de Outubro';
            $schoolDistrict = 'Nampula';
            $schoolProvince = 'Nampula';

            // Parse student data
            $studentName = strtoupper($certificate->student_name);
            $studentSex = $certificate->student_sex == 'M' ? 'Masculino' : 'Feminino';
            $studentSexNascido = $certificate->student_sex == 'M' ? 'nascido' : 'nascida';
            $studentSexFilho = $certificate->student_sex == 'M' ? 'filho' : 'filha';

            // Get student's full details from the student model if available
            $student = $certificate->student ?? null;
            $birthPlace = $student?->birth_place ?? 'Nampula';
            $birthDistrict = $student?->birth_district ?? 'Nampula';
            $birthProvince = $student?->birth_province ?? 'Nampula';

            $fatherName = $student?->father_name ?? '---';
            $motherName = $student?->mother_name ?? '---';

            // Format date of birth in Portuguese
            $months = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
            $dob = $certificate->student_dob ? \Carbon\Carbon::parse($certificate->student_dob) : null;
            $dobFormatted = $dob ? $dob->format('d') . ' de ' . $months[$dob->month - 1] . ' de ' . $dob->format('Y') : '---';

            // Area based on class/turma
            $area = 'Comunicação e Ciências Sociais';
        @endphp

        <p class="body-text">
            <span class="secretary-name">{{ $secretaryName }}</span>, {{ $secretaryTitle }}, {{ $secretaryRole }}, distrito de {{ $schoolDistrict }}, província de {{ $schoolProvince }}, CERTIFICO em cumprimento do despacho exarado em requerimento que fica arquivado nesta secretaria que <span class="student-name">{{ $studentName }},</span> do sexo {{ $studentSex }}, natural de {{ $birthPlace }}, distrito de {{ $birthDistrict }}, província de {{ $birthProvince }}, {{ $studentSexNascido }} no dia {{ $dobFormatted }}, {{ $studentSexFilho }} de {{ $fatherName }} e de {{ $motherName }}, concluiu no Colégio Politécnico de Moçambique em {{ $certificate->academic_year }} a {{ $certificate->class_level }}ª Classe, do curso diurno, na área de {{ $area }}, tendo obtido os seguintes resultados:
        </p>

        <!-- Grades Table -->
        <div class="grades-section">
            <table class="grades-table">
                <thead>
                    <tr>
                        <th style="width: 28%;">Disciplina</th>
                        <th style="width: 10%;">1º Trim</th>
                        <th style="width: 10%;">2º Trim</th>
                        <th style="width: 10%;">3º Trim</th>
                        <th style="width: 10%;">MFD</th>
                        @if($hasNE ?? true)
                        <th style="width: 10%;">NE</th>
                        @endif
                        <th style="width: 12%;">NF</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($certificate->subject_grades as $subject => $grades)
                    <tr>
                        <td class="subject-name">{{ $subject }}</td>
                        <td>{{ $grades['nf1'] }}</td>
                        <td>{{ $grades['nf2'] }}</td>
                        <td>{{ $grades['nf3'] }}</td>
                        <td>{{ $grades['mfd'] }}</td>
                        @if($hasNE ?? true)
                        <td>{{ $grades['ne'] !== null && $grades['ne'] > 0 ? $grades['ne'] : '-' }}</td>
                        @endif
                        <td><strong>{{ $grades['final'] }}</strong></td>
                    </tr>
                    @endforeach
                    <tr class="total-row">
                        <td class="subject-name"><strong>MÉDIA FINAL</strong></td>
                        <td colspan="{{ ($hasNE ?? true) ? 5 : 4 }}"></td>
                        <td><strong>{{ number_format($certificate->final_average, 0) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Results Reference - Exactly as Word -->
        @php
            $examPauta = $certificate->exam_pauta ?? '---';
            $examChamada = $certificate->exam_chamada ?? '1ª';
            $examNumber = $certificate->exam_number ?? '---';
        @endphp
        <p class="results-reference">
            Os resultados constam da pauta de Exames {{ $examPauta }} da {{ $examChamada }} chamada, nº {{ $examNumber }} de {{ $certificate->academic_year }}, código do aluno {{ $certificate->student_id_number }}. E, por ser verdade passo o presente Certificado que assino e autentico com carimbo a tinta de óleo em uso neste Estabelecimento de Ensino.
        </p>

        <!-- Date - Exactly as Word -->
        @php
            $issueDate = $certificate->issued_at ?? now();
            $monthName = $months[$issueDate->month - 1];
        @endphp
        <p class="date-section">
            Nampula, aos {{ $issueDate->format('d') }} de {{ $monthName }} de {{ $issueDate->format('Y') }}
        </p>

        <!-- Signatures - Exactly as Word -->
        <div class="signatures">
            <p class="signature-extrai-conferi">
                Extrai: ______________________&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Conferi: __________________________
            </p>

            <div class="signature-row">
                <div class="signature-left">
                    <p class="signature-title">O Chefe da Secretaria</p>
                </div>
                <div class="signature-right">
                    <p class="signature-title">O Director da Escola</p>
                </div>
            </div>

            <div class="signature-row" style="margin-top: 30px;">
                <div class="signature-left">
                    <div class="signature-line"></div>
                </div>
                <div class="signature-right">
                    <div class="signature-line"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- QR Code for verification -->
    <div class="qr-section">
        <img src="data:image/png;base64,{{ $qrCode }}" alt="QR Code">
        <p>Verificar</p>
        <p>{{ $certificate->certificate_number }}</p>
    </div>

    <div class="verification-info">
        <p>Documento verificável em:</p>
        <p>{{ str_replace(['http://', 'https://'], '', url('/')) }}/verificar-certificado</p>
    </div>
</body>
</html>
