<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Cartao de Estudante - {{ $studentId }}</title>
    <style>
        @page {
            size: 85.6mm 54mm;
            margin: 0;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            width: 85.6mm;
            height: 54mm;
            margin: 0;
            padding: 0;
            position: relative;
        }

        .background-image {
            position: absolute;
            top: 0;
            left: 0;
            width: 85.6mm;
            height: 54mm;
            z-index: -1;
        }

        .card {
            width: 85.6mm;
            height: 54mm;
            position: absolute;
            top: 0;
            left: 0;
            z-index: 1;
        }

        .photo-container {
            position: absolute;
            top: 11mm;
            right: 8mm;
            width: 22mm;
            height: 28mm;
            overflow: hidden;
        }

        .photo-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            opacity: 0.75;
        }

        .photo-placeholder {
            width: 100%;
            height: 100%;
            background: #f0f0f0;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #999;
            font-size: 7pt;
        }

        .student-info {
            position: absolute;
            bottom: 2mm;
            right: 8mm;
            width: 22mm;
            text-align: center;
        }

        .student-name {
            font-size: 9pt;
            font-weight: bold;
            text-transform: uppercase;
            color: #000000;
            word-wrap: break-word;
            overflow-wrap: break-word;
            line-height: 1.1;
        }

        .student-id {
            color: #cc0000;
            font-size: 9pt;
            font-weight: bold;
            margin-top: 1mm;
        }
    </style>
</head>
<body>
    @php
        $bgPath = public_path('images/templates/student_card_background.png');
        $bgData = '';
        if (file_exists($bgPath)) {
            $bgData = 'data:image/png;base64,' . base64_encode(file_get_contents($bgPath));
        }
    @endphp
    @if($bgData)
        <img src="{{ $bgData }}" class="background-image" alt="">
    @endif
    <div class="card">
        <div class="photo-container">
            @if(!empty($photoData))
                {{-- Use photo with background removed --}}
                <img src="{{ $photoData }}" alt="Foto">
            @elseif($photoPath && file_exists($photoPath))
                {{-- Fallback to original photo --}}
                <img src="{{ $photoPath }}" alt="Foto">
            @else
                <div class="photo-placeholder">FOTO</div>
            @endif
        </div>

        <div class="student-info">
            <div class="student-name">{{ $studentName }}</div>
            <div class="student-id">ID: {{ $studentId }}</div>
        </div>
    </div>
</body>
</html>
