<?php
$seenIcon = (!!$seen ? 'check-double' : 'check');
$timeAndSeen = "<span data-time='$created_at' class='message-time'>
        ".($isSender ? "<span class='fas fa-$seenIcon' visto há '></span>" : '' )." <span class='time'>$timeAgo</span>
    </span>";
?>

<div class="message-card @if($isSender) mc-sender @endif" data-id="{{ $id }}" data-sender="{{ $sender }}" data-owner='{{$owner_id}}'>
    {{-- Delete Message Button --}}
    @if ($isSender)
        <div class="actions">
            <i class="fas fa-trash delete-btn" data-id="{{ $id }}"></i>
        </div>
    @endif
    {{-- Card --}}
    <div class="message-card-content" style="
        background: {{ $isSender ? 'rgba(33, 150, 243, 0.1)' : 'rgba(76, 175, 80, 0.1)' }};
        border-radius: 8px;
        padding: 8px 12px;
        border: 1px solid {{ $isSender ? 'rgba(33, 150, 243, 0.3)' : 'rgba(76, 175, 80, 0.3)' }};
    ">
        @if (@$attachment->type != 'image' || $message)
        @if ($owner_id)
        <div class="message-sender-name" style="margin-bottom: 4px;">
            <span class="sender-name-badge" style="
                font-size: 11px;
                font-weight: 600;
                color: {{ $isSender ? '#2196F3' : '#4CAF50' }};
                display: block;
                letter-spacing: 0.2px;
            ">{{$user->name}}</span>
        </div>
        @endif
            <div class="message" style="
                line-height: 1.5;
                word-wrap: break-word;
            ">
                {!! ($message == null && $attachment != null && @$attachment->type != 'file') ? $attachment->title : nl2br($message) !!}
                {!! $timeAndSeen !!}
                {{-- If attachment is a file --}}
                @if(@$attachment->type == 'file')
                <a href="{{ route(config('chatify.attachments.download_route_name'), ['fileName'=>$attachment->file]) }}" class="file-download">
                    <span class="fas fa-file"></span> {{$attachment->title}}</a>
                @endif
            </div>
        @endif
        @if(@$attachment->type == 'image')
        <div class="image-wrapper" style="text-align: {{$isSender ? 'end' : 'start'}}">
            @if ($owner_id)
            <div class="message-sender-name" style="margin-bottom: 6px; text-align: {{ $isSender ? 'right' : 'left' }};">
                <span class="sender-name-badge" style="
                    font-size: 11px;
                    font-weight: 600;
                    color: {{ $isSender ? '#2196F3' : '#4CAF50' }};
                    display: inline-block;
                    letter-spacing: 0.2px;
                ">{{$user->name}}</span>
            </div>
            @endif
            <div class="image-file chat-image" style="background-image: url('{{ Chatify::getAttachmentUrl($attachment->file) }}')">
                <div>{{ $attachment->title }}</div>
            </div>
            <div style="margin-top: 6px;">
                {!! $timeAndSeen !!}
            </div>
        </div>
        @endif
    </div>
</div>

<style>
/* Melhorias adicionais para o chat */
.message-card {
    max-width: 85%;
    clear: both;
    margin-bottom: 12px;
}

.message-card.mc-sender {
    float: right;
    margin-left: auto;
}

.message-card:not(.mc-sender) {
    float: left;
    margin-right: auto;
}

.message-time {
    font-size: 10px;
    opacity: 0.6;
    margin-left: 8px;
    display: inline-block;
    white-space: nowrap;
}

.message-time .time {
    font-style: italic;
}

.image-wrapper {
    max-width: 100%;
}

.chat-image {
    max-width: 100%;
    width: 100%;
    height: 200px;
    background-size: cover;
    background-position: center;
    border-radius: 8px;
    overflow: hidden;
}
</style>
