<?php

namespace App\Exports;

use App\Models\Classroom;
use LaravelMultipleGuards\Traits\FindGuard;
use App\Models\Exam;
use App\Models\Subject;
use App\Models\Trimester;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Date;
use Maatwebsite\Excel\Concerns\WithFooter;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup\Image;

class AllSubject implements FromView, ShouldAutoSize, WithEvents
{
    use FindGuard;
    private $condition;
    public $user;
    public $schoolName, $subjectName, $className;

    public function __construct($condition)
    {
        $this->condition = $condition;

        $this->schoolName = 'COLÉGIO POLITÉCNICO DE MOÇAMBIQUE'; // Replace with your school name // Fetch subject name
        $this->className = Classroom::query()->where('id', $this->condition['class_id'])->first()->name; // Fetch class name


    }

        public function view(): View
        {
            return view('exports.allsubject', [
                'models' => Exam::query()
                    ->select('exams.student_id', 'exams.classroom_id', 'exams.trimester_id') // Replace '...' with other columns you want to select
                    ->distinct('exams.student_id') // Use distinct on the student_id column
                    ->join('users', 'exams.student_id', '=', 'users.id') // Join the students table
                    ->with(['subject', 'student']) // Assuming 'student' is the relationship with the student table
                    ->orderBy('users.name') // Order by student name
                    ->where('exams.classroom_id', $this->condition['class_id'])
                    ->where('exams.year', $this->condition['year'])
                    ->where('exams.trimester_id', $this->condition['trimester_id'])
                    ->get(),
                    "classname"=> $this->className,
                    "class_id"=>$this->condition['class'],
                    //dd($query->toSql(), $query->getBindings());
                   
                ]);
            }



    public function registerEvents(): array
    {
        $logoPath = public_path('assets/images/logo.png');
        $this->user = $this->findGuardType()->user();

        return [
            AfterSheet::class => function (AfterSheet $event) use ($logoPath) {
                // Set the height of the logo row
                $event->sheet->getRowDimension(1)->setRowHeight(80); // Adjust image height as needed

                // Create a drawing and set the image
                $drawing = new Drawing();
                $drawing->setPath($logoPath);
                $drawing->setWorksheet($event->sheet->getDelegate());
                $drawing->setCoordinates('D1'); // Adjust the cell coordinates as needed
                $drawing->setHeight(80); // Adjust image height as needed

                // Add the school name in the same cell as the logo
                $trimesterNameCell = $event->sheet->getCell('C1');
                $trimesterNameCell->setValue($this->condition['class']." classe - " .$this->className." - ".$this->condition['trimester_id']. 'º Trimestre'); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $schoolNameCell = $event->sheet->getCell('D1');
                $schoolNameCell->setValue($this->schoolName); // Use the school name from the view
                
                /*

                // Add the school name in the same cell as the logo
                $subjectNameCell = $event->sheet->getCell('G1');
                $subjectNameCell->setValue("Português"); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $classNameCell = $event->sheet->getCell('B1');
                $classNameCell->setValue($this->className); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $trime3NameCell = $event->sheet->getCell('R1');
                $trime3NameCell->setValue('Inglês'); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $trime2NameCell = $event->sheet->getCell('L1');
                $trime2NameCell->setValue('Matemática'); // Use the school name from the view

                $uNameCell = $event->sheet->getCell('X1');
                $uNameCell->setValue('Francês'); // Use the school name from the view

                $zNameCell = $event->sheet->getCell('AC1');
                $zNameCell->setValue('História'); // Use the school name from the view

                $aeNameCell = $event->sheet->getCell('AI1');
                $aeNameCell->setValue('Geografia'); // Use the school name from the view

                $akNameCell = $event->sheet->getCell('AP1');
                $akNameCell->setValue('Física'); // Use the school name from the view

                $arNameCell = $event->sheet->getCell('AW1');
                $arNameCell->setValue('Química'); // Use the school name from the view

                $awNameCell = $event->sheet->getCell('BA1');
                $awNameCell->setValue('Biologia'); // Use the school name from the view

                $bcNameCell = $event->sheet->getCell('BM1');
                $bcNameCell->setValue('Educação Visual'); // Use the school name from the view

                $biNameCell = $event->sheet->getCell('BG1');
                $biNameCell->setValue('Educação Fisica'); // Use the school name from the view

                $boNameCell = $event->sheet->getCell('BS1');
                $boNameCell->setValue('Informática'); // Use the school name from the view

                $btNameCell = $event->sheet->getCell('BY1');
                $btNameCell->setValue('ciências naturais'); // Use the school name from the view

                $bkoNameCell = $event->sheet->getCell('CE1');
                $bkoNameCell->setValue('Caligrafia'); // Use the school name from the view

                $bzoNameCell = $event->sheet->getCell('CK1');
                $bzoNameCell->setValue('Ciências sociais'); // Use the school name from the view

                $byoNameCell = $event->sheet->getCell('CQ1');
                $byoNameCell->setValue('Geometria Descritiva'); // Use the school name from the view

                $bxoNameCell = $event->sheet->getCell('CW1');
                $bxoNameCell->setValue('Filosofia'); // Use the school name from the view
                */
                // Remove the background color of the first row
                $event->sheet->getStyle('1:1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_NONE);

                // Set font color for the first row
                $event->sheet->getStyle('1:1')->getFont()->getColor()
                    ->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLACK);

                // Make the first row bold
                $event->sheet->getStyle('1:1')->getFont()->setBold(true);
            },

            /* AfterSheet::class => function (AfterSheet $event) {
                // Set protection
                // Check user role
                if ($this->user->role == 0) {
                    //no protetctions
                }
                else {
                    // Set protection if the user role is 0
                    $event->sheet->getDelegate()->getProtection()->setSheet(true);
                }
            }, */

        ];
    }



    public function headings(): array
    {
        return [
            'Subject: ' . $this->subjectName,
            'Class: ' . $this->className,
            '', // Add more columns as needed
        ];
    }
}
